from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from PyQt4 import QtXml
from qgis.gui import *
import os
import pysal
import numpy as np
import string
from scipy.cluster import hierarchy
from scipy.spatial import distance
from testdialog import testDialog
from testdialog2 import testDialog2
from testdialog2b import testDialog2b
from testdialog2c import testDialog2c
from testdialogclass import testDialogClass
from testdialog2d import testDialog2d
from testdialog4 import testDialog4
from testdialog4b import testDialog4b

# Our main class for the plugin
class SpatialAnalysis:

  def __init__(self, iface):
    # Save reference to the QGIS interface
    self.iface = iface

  def initGui(self):
    # Create action that will start plugin configuration
    self.action = QAction("Autocorrelation", self.iface.mainWindow())
    QObject.connect(self.action, SIGNAL("activated()"), self.run)
    self.actionb = QAction("Inegalite", self.iface.mainWindow())
    QObject.connect(self.actionb, SIGNAL("activated()"), self.runb)
    self.actionc= QAction("Specialisation", self.iface.mainWindow())
    QObject.connect(self.actionc, SIGNAL("activated()"), self.runc)
    self.actiond= QAction("Correlation", self.iface.mainWindow())
    QObject.connect(self.actiond, SIGNAL("activated()"), self.rund)
    self.actione= QAction("Clustering", self.iface.mainWindow())
    QObject.connect(self.actione, SIGNAL("activated()"), self.rune)


    # Add toolbar button and menu item
    self.iface.addPluginToMenu("&Analyse spatiale...", self.action)
    self.iface.addPluginToMenu("&Analyse spatiale...", self.actionb)
    self.iface.addPluginToMenu("&Analyse spatiale...", self.actionc)
    self.iface.addPluginToMenu("&Analyse spatiale...", self.actiond)
    self.iface.addPluginToMenu("&Analyse spatiale...", self.actione)

  def unload(self):
    # Remove the plugin menu item and icon
    self.iface.removePluginMenu("&Analyse spatiale...",self.action)
    self.iface.removePluginMenu("&Analyse spatiale...",self.actionb)
    self.iface.removePluginMenu("&Analyse spatiale...",self.actionc)
    self.iface.addPluginToMenu("&Analyse spatiale...", self.actiond)
    self.iface.addPluginToMenu("&Analyse spatiale...", self.actiond)
 
  def run(self): 
    # Get the user input, starting with the table name
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calcul)
        self.dlg.show()

  def calcul(self):
        table=self.dlg.ui.comboBox.currentText()
        global ind_table
        for j in range(count):
          if str(table)==str(lay[j]) :
            ind_table=j
        global aLayer
        aLayer = allLayers[int(ind_table)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_6.addItems(["Moran","Geary","Getis and Ord","Gamma","LISA","GO Local"]) #un jour prevoir Join Count
        self.dlg2.ui.comboBox_9.addItems(["Queen","Rook", "Voisins les plus proches","Distance"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2)
        self.dlg2.show()

  def calcul2(self):
        champs=self.dlg2.ui.comboBox.currentText()
        id=self.dlg2.ui.comboBox_2.currentText()
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        voi=self.dlg2.ui.comboBox_9.currentText()
        champind=provider.fieldNameIndex(str(champs))
        idind=provider.fieldNameIndex(str(id))
        src=allLayers[int(ind_table)].publicSource()
        val=self.dlg2.ui.lineEdit_10.text()
        if voi=="Queen":
             w = pysal.queen_from_shapefile(str(src),idVariable=str(id)) 
        if voi=="Rook":
             w = pysal.rook_from_shapefile(str(src),idVariable=str(id)) 
        if voi=="Voisins les plus proches":
             w = pysal.knnW_from_shapefile(str(src),k=int(val)) 
        if voi=="Distance":
             w = pysal.threshold_binaryW_from_shapefile(str(src),float(val), idVariable=str(id)) 
        feat = QgsFeature()
        fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
        table=[]
        while fit1.nextFeature(feat):
                 attrsstart=float(feat.attributes()[champind])  
                 table=table+[attrsstart]
        y = np.array(table)
        if str(indicateur)=="Moran":
                 mi = pysal.Moran(y, w) 
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<b>Indice de Moran</b> : '+str(mi.I)+'<br><br><b> Moran attendu</b> : ' +str(mi.EI)+ '<br><br><b> P_Value</b> : ' +str(mi.p_norm)+ '<br><br><b> Z_Value</b> : ' +str(mi.z_norm)
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
        if str(indicateur)=="Geary":
                 gc = pysal.Geary(y, w)
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<b>Indice de Geary</b> : '+str(gc.C)+'<br><br><b> Geary attendu</b> : ' +str(gc.EC) + '<br><br><b> P_Value</b> : ' +str(gc.p_norm)+ '<br><br><b> Z_Value</b> : ' +str(gc.z_norm)
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
        if str(indicateur)=="Gamma":
                 g = pysal.Gamma(y,w)
                 g.g
                 g.g_z
                 g.p_sim_g
        if str(indicateur)=="Getis and Ord":
                 w.transform = "B"
                 from pysal.esda.getisord import G
                 g = G(y, w)
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<b>Indice de Getis and Ord</b> : '+str(g.G)+'<br><br><b> Getis and Ord attendu</b> : ' +str(g.EG) + '<br><br><b> P_Value</b> : ' +str(g.p_norm)+ '<br><br><b> Z_Value</b> : ' +str(g.z_norm)
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
        if str(indicateur)=="LISA":
                 lm = pysal.Moran_Local(y,w) 
                 b=lm.p_sim
                 taille=len(b)
                 nbcol=int(provider.fields().count())
                 provider.addAttributes([QgsField(str(indicateur), QVariant.Double)])
                 aLayer.startEditing()
                 for k in range(taille):
                     aLayer.changeAttributeValue(k,nbcol,float(b[k]))
                 aLayer.commitChanges()
        if str(indicateur)=="GO Local":
                 w.transform = "B"
                 from pysal.esda.getisord import G_Local
                 lg = G_Local(y, w)
                 b=lg.p_sim
                 taille=len(b)
                 nbcol=int(provider.fields().count())
                 provider.addAttributes([QgsField(str(indicateur), QVariant.Double)])
                 aLayer.startEditing()
                 for k in range(taille):
                     aLayer.changeAttributeValue(k,nbcol,float(b[k]))
                 aLayer.commitChanges()

  def runb(self): 
    # Get the user input, starting with the table name
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculb)
        self.dlg.show()

  def calculb(self):
        table=self.dlg.ui.comboBox.currentText()
        global ind_table
        for j in range(count):
          if str(table)==str(lay[j]) :
            ind_table=j
        global aLayer
        aLayer = allLayers[int(ind_table)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2b(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Gini", "Gini Region", "Gini Spatial", "Theil", "Theil Region", "Theil Spatial"])
        self.dlg2.ui.comboBox_9.addItems(["","Queen","Rook", "Voisins les plus proches","Distance"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2b)
        self.dlg2.show()

  def calcul2b(self):
        champs=self.dlg2.ui.comboBox.currentText()
        id=self.dlg2.ui.comboBox_2.currentText()
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        voi=self.dlg2.ui.comboBox_9.currentText()
        val=self.dlg2.ui.lineEdit_10.text()
        champind=provider.fieldNameIndex(str(champs))
        idind=provider.fieldNameIndex(str(id))
        src=allLayers[int(ind_table)].publicSource()
        feat = QgsFeature()
        fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
        table=[]
        while fit1.nextFeature(feat):
                 attrsstart=float(feat.attributes()[champind])
                 table=table+[attrsstart]
        y = np.array(table)
        if str(indicateur)=="Gini":
                 gini_y= pysal.inequality.gini.Gini(y)
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<b>Indice de Gini</b> : '+str(gini_y.g)
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
        if str(indicateur)=="Gini Region":
                 feat2 = QgsFeature()
                 fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([idind]))
                 table2=[]
                 while fit2.nextFeature(feat2):
                        attrsstart=int(feat2.attributes()[idind])
                        table2=table2+[attrsstart]
                 s=list(set(table2))
                 nbcol=int(provider.fields().count())
                 provider.addAttributes([QgsField(str(indicateur), QVariant.Double)])
                 aLayer.startEditing()
                 for i in s:
                        table3=[]
                        for j in range(len(table2)):
                             if table2[j]==i:
                                 table3=table3+[table[j]]
                        gini_y = pysal.inequality.gini.Gini(np.array(table3))
                        for j in range(len(table2)):
                             if table2[j]==i:
                                 aLayer.changeAttributeValue(j,nbcol,float(gini_y.g))
                 aLayer.commitChanges() 
                 w = pysal.regime_weights(table2)
                 gs = pysal.inequality.gini.Gini_Spatial(y,w)
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<b>Indice de Gini</b> : '+str(gs.g) + '<br><br><b>Inegalite des elements qui ne sont pas voisins</b> : ' + str(gs.wcg) + '<br><br><b>Inegalite attendue des elements qui ne sont pas voisins</b> : ' + str(gs.e_wcg)
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
        if str(indicateur)=="Gini Spatial":
                 if voi=="Queen":
                     w = pysal.queen_from_shapefile(str(src),idVariable=str(id))
                 if voi=="Rook":
                     w = pysal.rook_from_shapefile(str(src),idVariable=str(id)) 
                 if voi=="Voisins les plus proches":
                     w = pysal.knnW_from_shapefile(str(src),k=int(val)) 
                 if voi=="Distance":
                     w = pysal.threshold_binaryW_from_shapefile(str(src),float(val), idVariable=str(id)) 
                 table4=[]
                 feat3 = QgsFeature()
                 fit3 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([idind]))
                 while fit3.nextFeature(feat3):
                     attrsstart=str(feat3.attributes()[idind])
                     table4=table4+[attrsstart]
                 feat2 = QgsFeature()
                 fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([idind]))
                 table2=[]
                 i=0
                 nbcol=int(provider.fields().count())
                 provider.addAttributes([QgsField(str(indicateur), QVariant.Double)])
                 aLayer.startEditing()
                 while fit2.nextFeature(feat2):
                         val=table4[i]
                         nei=w.neighbors[str(val)]
                         table3=[table[i]]
                         for i2 in nei:
                             table3=table3+[table[table4.index(i2)]]
                         y = np.array(table3)
                         gini_y = pysal.inequality.gini.Gini(y)
                         aLayer.changeAttributeValue(i,nbcol,float(gini_y.g))
                         i=i+1
                 aLayer.commitChanges()

        if str(indicateur)=="Theil":
                 theil_y= pysal.inequality.theil.Theil(y)
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<b>Indice de Theil</b> : '+str(theil_y.T)
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
        if str(indicateur)=="Theil Region":
                 feat2 = QgsFeature()
                 fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([idind]))
                 table2=[]
                 while fit2.nextFeature(feat2):
                        attrsstart=int(feat2.attributes()[idind])
                        table2=table2+[attrsstart]
                 s=list(set(table2))
                 nbcol=int(provider.fields().count())
                 provider.addAttributes([QgsField(str(indicateur), QVariant.Double)])
                 aLayer.startEditing()
                 for i in s:
                        table3=[]
                        for j in range(len(table2)):
                             if table2[j]==i:
                                 table3=table3+[table[j]]
                        theil_y = pysal.inequality.theil.Theil(table3)
                        for j in range(len(table2)):
                             if table2[j]==i:
                                 aLayer.changeAttributeValue(j,nbcol,float(theil_y.T))
                 aLayer.commitChanges()
                 theil_d = pysal.inequality.theil.TheilD(y,table2)
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<b>Indice de Theil</b> : '+str(theil_d.T) + '<br><br><b>Indice de Theil pour les elements qui ne sont pas voisins</b> : ' + str(theil_d.wg) + '<br><br><b>Indice de Theil pour les elements qui sont voisins</b> : ' + str(theil_d.bg)
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
        if str(indicateur)=="Theil Spatial":
                 if voi=="Queen":
                     w = pysal.queen_from_shapefile(str(src),idVariable=str(id))
                 if voi=="Rook":
                     w = pysal.rook_from_shapefile(str(src),idVariable=str(id)) 
                 if voi=="Voisins les plus proches":
                     w = pysal.knnW_from_shapefile(str(src),k=int(val)) 
                 if voi=="Distance":
                     w = pysal.threshold_binaryW_from_shapefile(str(src),float(val), idVariable=str(id)) 
                 table4=[]
                 feat3 = QgsFeature()
                 fit3 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([idind]))
                 while fit3.nextFeature(feat3):
                     attrsstart=str(feat3.attributes()[idind])
                     table4=table4+[attrsstart]
                 feat2 = QgsFeature()
                 fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([idind]))
                 table2=[]
                 i=0
                 nbcol=int(provider.fields().count())
                 provider.addAttributes([QgsField(str(indicateur), QVariant.Double)])
                 aLayer.startEditing()
                 while fit2.nextFeature(feat2):
                         val=table4[i]
                         nei=w.neighbors[str(val)]
                         table3=[table[i]]
                         for i2 in nei:
                             table3=table3+[table[table4.index(i2)]]
                         theil_y = pysal.inequality.theil.Theil(table3)
                         aLayer.changeAttributeValue(i,nbcol,float(theil_y.T))
                         i=i+1
                 aLayer.commitChanges() 

  def runc(self): 
    # Get the user input, starting with the table name
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculc)
        self.dlg.show()

  def calculc(self):
        table=self.dlg.ui.comboBox.currentText()
        global ind_table
        for j in range(count):
          if str(table)==str(lay[j]) :
            ind_table=j
        global aLayer
        aLayer = allLayers[int(ind_table)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
        self.dlg2 = testDialog2c(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2c)
        self.dlg2.show()

  def calcul2c(self):
        champs=self.dlg2.ui.textEdit_10.toPlainText()
        ch=string.split(str(champs), ";")
        a=np.arange(field.count())
        feat2 = QgsFeature()
        fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes(a))
        table2=[]
        table3=np.array([0])
        somme=0
        while fit2.nextFeature(feat2):
             c=0
             table3b=[]
             for i in range(len(ch)):
                 champind=provider.fieldNameIndex(str(ch[i]))
                 attrsstart=float(feat2.attributes()[champind])
                 c=c+attrsstart
                 somme=somme+attrsstart
                 table3b=table3b+[attrsstart]
             table2=table2+[c]
             table3=table3+np.array(table3b)
        nbcol=int(provider.fields().count())
        for i in range(len(ch)):
             provider.addAttributes([QgsField(str(ch[i])+"_SPE", QVariant.Double)])
        feat3= QgsFeature()
        fit3= provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes(a))
        aLayer.startEditing()
        indfin=0 
        while fit3.nextFeature(feat3):
             for i in range(len(ch)):
                 champind=provider.fieldNameIndex(str(ch[i]))
                 attrsstart=float(feat3.attributes()[champind])
                 fin= (attrsstart/float(table3[i]))/(table2[indfin]/float(somme))
                 aLayer.changeAttributeValue(indfin,nbcol+i,float(fin))
             indfin=indfin+1
        aLayer.commitChanges() 

  def rund(self): 
    # Get the user input, starting with the table name
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculd)
        self.dlg.show()

  def calculd(self):
        table=self.dlg.ui.comboBox.currentText()
        global ind_table
        for j in range(count):
          if str(table)==str(lay[j]) :
            ind_table=j
        global aLayer
        aLayer = allLayers[int(ind_table)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
        self.dlg2 = testDialog2d(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox2.addItems(fields)
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2d)
        self.dlg2.show()

  def calcul2d(self):
        champ=self.dlg2.ui.comboBox.currentText()
        champ2=self.dlg2.ui.comboBox2.currentText()
        global champind
        champind=provider.fieldNameIndex(str(champ))
        champ2ind=provider.fieldNameIndex(str(champ2))
        feat2 = QgsFeature()
        fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind,champ2ind]))
        global table2
        table2=[]
        global table3
        table3=[]
        while fit2.nextFeature(feat2):
                 attrsstart=float(feat2.attributes()[champind])
                 attrsstart2=float(feat2.attributes()[champ2ind])
                 table2=table2+[attrsstart]
                 table3=table3+[attrsstart2]
        from scipy import stats
        global slope, intercept, r_value, p_value, std_err
        slope, intercept, r_value, p_value, std_err = stats.linregress(np.array(table2),np.array(table3))
        self.dlg4 = testDialog4b(self.iface.mainWindow())
        texthtml='<b>Formule</b> : '+str(slope)+' x + '+str(intercept)+'<br><br><b>R2</b> : '+str(r_value*r_value)+'<br><br><b>std_err</b> : '+str(std_err)+'<br><br> * cliquez sur ok pour calculer les residus ou cliquez sur cancel pour annuler '
        self.dlg4.ui.textBrowser.setHtml(texthtml)
        QObject.connect(self.dlg4.ui.buttonBox, SIGNAL("accepted()"), self.calcul2db)
        self.dlg4.show()

  def calcul2db(self):
        feat2 = QgsFeature()
        fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
        nbcol=int(provider.fields().count())
        provider.addAttributes([QgsField("RESIDUS", QVariant.Double)])
        aLayer.startEditing()
        i=0
        while fit2.nextFeature(feat2):
                 attrsstart=float(feat2.attributes()[champind])
                 appr = float(table3[i])-(float(slope)*float(attrsstart)+float(intercept))
                 aLayer.changeAttributeValue(i,nbcol,float(appr))
                 i=i+1
        aLayer.commitChanges() 

  def rune(self): 
    # Get the user input, starting with the table name
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calcule)
        self.dlg.show()

  def calcule(self):
        table=self.dlg.ui.comboBox.currentText()
        global ind_table
        for j in range(count):
          if str(table)==str(lay[j]) :
            ind_table=j
        global aLayer
        aLayer = allLayers[int(ind_table)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
        self.dlg2 = testDialogClass(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox2.addItems(['Euclidienne', 'Manhattan','Correlation'])
        self.dlg2.ui.comboBox4.addItems(['Minimum', 'Maximum','Moyenne', 'Mediane', 'Ward'])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2e)
        self.dlg2.show()

  def calcul2e(self):
        champs=self.dlg2.ui.textEdit_10.toPlainText()
        nbclus=int(self.dlg2.ui.textEdit_3.toPlainText())
        typedist=self.dlg2.ui.comboBox2.currentText()
        typeclass=self.dlg2.ui.comboBox4.currentText()
        ch=string.split(str(champs), ";")
        a=np.arange(field.count())
        feat2 = QgsFeature()
        fit2 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes(a))
        table2=[]
        somme=0
        while fit2.nextFeature(feat2):
             somme=somme+1
             table3=[]
             for i in range(len(ch)):
                 champind=provider.fieldNameIndex(str(ch[i]))
                 attrsstart=float(feat2.attributes()[champind])
                 table3=table3+[attrsstart]
             table2=table2+[(table3)]
        #QMessageBox.information(None, " message final : ", str(table2))
        #QMessageBox.information(None, " message final : ", str(table3))
        dissim=np.zeros((somme,somme))
        if typedist=="Euclidienne":
          for i in range(somme):
           for j in range(somme):
                dissim[int(i)][int(j)]=distance.euclidean(table2[i],table2[j])
        #QMessageBox.information(None, " message final : ", str(len(dissim)))
        if typedist=="Manhattan":
          for i in range(somme):
           for j in range(somme):
                dissim[int(i)][int(j)]=distance.cityblock(table2[i],table2[j])
        if typedist=="Correlation":
          for i in range(somme):
           for j in range(somme):
                dissim[int(i)][int(j)]=distance.correlation(table2[i],table2[j])
        if typeclass=="Minimum":
            hier = hierarchy.single(dissim)
        if typeclass=="Maximum":
            hier = hierarchy.complete(dissim)
        if typeclass=="Moyenne":
            hier = hierarchy.average(dissim)
        if typeclass=="Mediane":
            hier = hierarchy.median(dissim)
        if typeclass=="Ward":
            hier = hierarchy.ward(dissim)
        part=hierarchy.fcluster(hier,nbclus,'maxclust')
        stat=np.zeros((len(ch),nbclus))
        stateff=np.zeros(nbclus)
        for i in range(somme):
             numclus=part[i]
             stateff[numclus-1]=stateff[numclus-1]+1
             for j in range(len(ch)):
                   stat[j][numclus-1]=stat[j][numclus-1]+table2[i][j]
        for i in range(nbclus):
             for j in range(len(ch)):
                   stat[j][i]=stat[j][i]/float(stateff[i])
        #QMessageBox.information(None, " message final : ", str(stat))
        feat3 = QgsFeature()
        fit3 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([a]))
        nbcol=int(provider.fields().count())
        provider.addAttributes([QgsField("CLASSE", QVariant.Double)])
        aLayer.startEditing()
        for i in range(somme):
                 aLayer.changeAttributeValue(i,nbcol,int(part[i]))
        aLayer.commitChanges()
        textfin='<Table><tr><th></th>'
        for i in range(nbclus):
               nom=i+1
               textfin=textfin+'<th>'+str(nom)+'</th>'
        textfin=textfin+'<th>Moyenne</th></tr>'
        for i in range(len(ch)):
            textfin=textfin+'<tr><td><b>'+str(ch[i])+'</b></td>'
            moy=0
            for j in range(nbclus):
                 textfin=textfin+'<td>'+str(stat[i][j])+'</td>'
                 moy=moy+stat[i][j]
            moy=moy/float(nbclus)
            textfin=textfin+'<td>'+str(moy)+'</td></tr>'
        textfin=textfin+'</table>'
        QMessageBox.information(None, " Message final : ", str(textfin))