from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from PyQt4 import QtXml
from qgis.gui import *
# Initialize Qt resources from file resources.py
import os
path=os.getcwd()
chpath=len(path)-3
path2=path[:chpath]
pathof=path2+"apps\\qgis\\python\\plugins\\network_analysis"
import sys
sys.path.append(pathof) 
import resources
import os
import community
import community as com
import networkx
import networkx as nx
from networkx import *
from testdialog import testDialog
from testdialog2 import testDialog2
from testdialog2b import testDialog2b
from testdialog3 import testDialog3
from testdialog4 import testDialog4
from testdialog5 import testDialog5
import operator
import numpy as np
import matplotlib.pyplot as plt
import random
import itertools as iter
from numpy import *
sys.path.remove(pathof) 
import csv

# Our main class for the plugin
class NetworkAnalysis:

  def __init__(self, iface):
    # Save reference to the QGIS interface
    self.iface = iface

  def initGui(self):
    # Create action that will start plugin configuration
    self.action = QAction(QIcon(":/plugins/network_analysis/icon.png"), \
        "Analyse de graphe", self.iface.mainWindow())
    QObject.connect(self.action, SIGNAL("activated()"), self.run)
    self.actionb = QAction("Analyse de vulnerabilite", self.iface.mainWindow())
    QObject.connect(self.actionb, SIGNAL("activated()"), self.runb)
    self.actionc = QAction("Detection communaute", self.iface.mainWindow())
    QObject.connect(self.actionc, SIGNAL("activated()"), self.runc)

    # Add toolbar button and menu item
    #self.iface.addToolBarIcon(self.action)
    self.iface.addPluginToMenu("&Analyse de graphe...", self.action)
    self.iface.addPluginToMenu("&Analyse de graphe...", self.actionb)
    self.iface.addPluginToMenu("&Analyse de graphe...", self.actionc)

  def unload(self):
    # Remove the plugin menu item and icon
    self.iface.removePluginMenu("&Analyse de graphe...",self.action)
    self.iface.removePluginMenu("&Analyse de graphe...",self.actionb)
    self.iface.removePluginMenu("&Analyse de graphe...",self.actionc)
    #self.iface.removeToolBarIcon(self.action)
 
  def run(self): 
    # Get the user input, starting with the table name
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table_noeud
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        self.dlg.ui.comboBox_2.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calcul)
        self.dlg.show()

  def calcul(self):
        table_noeud=self.dlg.ui.comboBox.currentText()
        table_arc=self.dlg.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_3.addItems(["non","oui"])
        self.dlg2.ui.comboBox_4.addItems(["non","oui"])
        self.dlg2.ui.comboBox_5.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Degree","Closeness","Eloignement","Betweenness","Clustering","Eigenvector","Vulnerabilite"])
        self.dlg2.ui.comboBox_7.addItems(["oui","non"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2)
        self.dlg2.show()

  def calcul2(self):
        arc_start=self.dlg2.ui.comboBox.currentText()
        arc_end=self.dlg2.ui.comboBox_2.currentText()
        oriente=self.dlg2.ui.comboBox_3.currentText()
        poids=self.dlg2.ui.comboBox_4.currentText()
        ponderation=self.dlg2.ui.comboBox_5.currentText()
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        norm=self.dlg2.ui.comboBox_7.currentText()
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        table=[]
        if str(poids)=="non":
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          table=table+[(attrsstart,attrsend)] 
         G=nx.Graph()
         if str(oriente)=="oui" :
          G=nx.DiGraph()
         G.add_edges_from(table)
        if str(poids)=="oui":
         distind=provider.fieldNameIndex(str(ponderation))
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind,distind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=feat.attributes()[distind]
          table=table+[(attrsstart,attrsend,attrsdist)] 
         G=nx.Graph()
         if str(oriente)=="oui" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        if str(indicateur)=="Betweenness" and str(poids)=="non" and str(norm)=="non" :
            b=betweenness_centrality(G,normalized=False)
        if str(indicateur)=="Betweenness" and str(poids)=="oui" and str(norm)=="non" :
            b=betweenness_centrality(G, normalized=False, weight='weight')
        if str(indicateur)=="Betweenness" and str(poids)=="non" and str(norm)=="oui" :
            b=betweenness_centrality(G)
        if str(indicateur)=="Betweenness" and str(poids)=="oui" and str(norm)=="oui" :
            b=betweenness_centrality(G,weight='weight')
        if str(indicateur)=="Eigenvector" and str(oriente)=="non" and str(norm)=="oui" :
            b=eigenvector_centrality(G)
            # a noter que le calcul du eigenvector ne tient pas compte des poids.
        if str(indicateur)=="Eigenvector" and str(oriente)=="oui" and str(norm)=="oui" :
            b=eigenvector_centrality(G)
            G2=reverse(G, copy=True)
            b2=eigenvector_centrality(G2)
        if str(indicateur)=="Eigenvector" and str(norm)=="non" :
            QMessageBox.information(None, " message final : ", "Ce calcul n\'a pas de sens. Par construction, eigenvector est normalise.")
            b=77777
        if str(indicateur)=="Closeness" and str(poids)=="non" and str(norm)=="non":
            b=closeness_centrality(G, normalized=False)
        if str(indicateur)=="Closeness" and str(poids)=="oui" and str(norm)=="non":
            b=closeness_centrality(G, normalized=False, distance=True)
        if str(indicateur)=="Closeness" and str(poids)=="non" and str(norm)=="oui":
            b=closeness_centrality(G)
        if str(indicateur)=="Closeness" and str(poids)=="oui" and str(norm)=="oui":
            b=closeness_centrality(G,distance=True)
        if str(indicateur)=="Clustering" and str(poids)=="non" and str(oriente)=="non" and str(norm)=="oui":
            b=clustering(G)
        if str(indicateur)=="Clustering" and str(poids)=="oui" and str(oriente)=="non" and str(norm)=="oui":
            b=clustering(G, weight='weight')
        if str(indicateur)=="Clustering" and str(oriente)=="oui":
            QMessageBox.information(None, " message final : ", "Ce calcul n\'a pas de sens. Le graphe doit etre oriente.")
            b=77777
        if str(indicateur)=="Clustering" and str(norm)=="non":
            QMessageBox.information(None, " message final : ", "Ce calcul n\'a pas de sens. Par construction, le clustering coefficient est normalise.")
            b=77777
        if str(indicateur)=="Vulnerabilite" and str(poids)=="non" and str(norm)=="non":
            b=closeness_vitality(G)
        if str(indicateur)=="Vulnerabilite" and str(poids)=="oui" and str(norm)=="non":
            b=closeness_vitality(G, weight='weight')
        if str(indicateur)=="Vulnerabilite" and str(norm)=="oui":
            QMessageBox.information(None, " message final : ", "Ce calcul n\'a pas de sens. Les indicateurs de vulnerabilite n\'ont pas de normalisation reconnue.")	
        if str(indicateur)=="Eloignement" and str(poids)=="non" and str(norm)=="non":
            spl=shortest_path_length(G)
            t=number_of_nodes(G)
            b2=[0]
            for i in range(t):
               b2=b2+[sum(spl[i+1].values())/(float(t)-1)]
            b=77777
        if str(indicateur)=="Eloignement" and str(poids)=="oui" and str(norm)=="non":
            spl=shortest_path_length(G, weight='weight')
            t=number_of_nodes(G)
            b2=[0]
            for i in range(t):
               b2=b2+[sum(spl[i+1].values())/(float(t)-1)]
            b=77777
        if str(indicateur)=="Eloignement" and str(norm)=="oui":
            QMessageBox.information(None, " message final : ", "Ce calcul n\'a pas de sens. Les indicateurs d\'eloignement n\'ont pas de normalisation reconnue.")
            b=77777
        if str(indicateur)=="Degree" and str(norm)=="non" and str(oriente)=="non" and str(poids)=="non":
            b=G.degree()
        if str(indicateur)=="Degree" and str(norm)=="non" and str(oriente)=="non" and str(poids)=="oui":
            b=G.degree(weight='weight')
        if str(indicateur)=="Degree" and str(norm)=="oui" and str(oriente)=="non" and str(poids)=="non":
            b=degree_centrality(G)
        if str(indicateur)=="Degree" and str(norm)=="oui" and str(oriente)=="non" and str(poids)=="oui":
            QMessageBox.information(None, " message final : ", "Calcul indisponible")
            b=77777
        if str(indicateur)=="Degree" and str(norm)=="oui" and str(oriente)=="oui":
            QMessageBox.information(None, " message final : ", "Ce calcul n\'a pas de sens.")
            b=77777
        if str(indicateur)=="Degree" and str(norm)=="non" and str(oriente)=="oui" and str(poids)=="oui":
            b=G.degree(weight='weight')
            b2=G.out_degree(weight='weight')
            b3=G.in_degree(weight='weight')
        if str(indicateur)=="Degree" and str(norm)=="non" and str(oriente)=="oui" and str(poids)=="non":
            b=G.degree()
            b2=G.out_degree(weight='weight')
            b3=G.in_degree(weight='weight')
        if b!=77777 :
         taille=len(b)
         aLayer2 = allLayers[int(ind_noeud)]
         provider2 = aLayer2.dataProvider()
         nbcol=int(provider2.fields().count())
         provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
         aLayer2.startEditing()
         for k in range(taille):
           aLayer2.changeAttributeValue(k,nbcol,b[k+1])
         aLayer2.commitChanges()
        if str(indicateur)=="Eloignement" and str(norm)=="non" :
         taille=t
         aLayer2 = allLayers[int(ind_noeud)]
         provider2 = aLayer2.dataProvider()
         nbcol=int(provider2.fields().count())
         provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
         aLayer2.startEditing()
         for k in range(taille):
           aLayer2.changeAttributeValue(k,nbcol,float(b2[k+1]))
         aLayer2.commitChanges()
        if str(indicateur)=="Eigenvector" and str(oriente)=="oui" :
         taille=len(b)
         aLayer2 = allLayers[int(ind_noeud)]
         provider2 = aLayer2.dataProvider()
         nbcol=int(provider2.fields().count())
         provider2.addAttributes([QgsField("Left_Eigenvector", QVariant.Double)])
         aLayer2.startEditing()
         for k in range(taille):
           aLayer2.changeAttributeValue(k,nbcol,float(b2[k+1]))
         aLayer2.commitChanges()
        if str(indicateur)=="Degree" and str(norm)=="non" and str(oriente)=="oui":
             taille=len(b)
             aLayer2 = allLayers[int(ind_noeud)]
             provider2 = aLayer2.dataProvider()
             provider2.addAttributes([QgsField("out_degree", QVariant.Double)])
             aLayer2.startEditing()
             for k in range(taille):
                 aLayer2.changeAttributeValue(k,nbcol+1,b2[k+1])
             aLayer2.commitChanges() 
             taille=len(b)
             aLayer2 = allLayers[int(ind_noeud)]
             provider2 = aLayer2.dataProvider()
             provider2.addAttributes([QgsField("in_degree", QVariant.Double)])
             aLayer2.startEditing()
             for k in range(taille):
                 aLayer2.changeAttributeValue(k,nbcol+2,b3[k+1])
             aLayer2.commitChanges() 
        QMessageBox.information(None, " message final : ", "Fin du calcul")
  #----------------------------------------------------------------------------------------------------------------------------------------                partie analyse de vulnerabilite              -----------------------------------------------------------------------------------------------------------------------------------
  def runb(self): 
    # Get the user input, starting with the table name
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table_noeud
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        self.dlg.ui.comboBox_2.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculb)
        self.dlg.show()

  def calculb(self):
        table_noeud=self.dlg.ui.comboBox.currentText()
        global table_arc
        table_arc=self.dlg.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2b(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_3.addItems(["non","oui"])
        self.dlg2.ui.comboBox_4.addItems(["non","oui"])
        self.dlg2.ui.comboBox_5.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Allongement moyen","Centralite information","Dynamique","Combinatoire"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2b)
        self.dlg2.show()

  def calcul2b(self):
        arc_start=self.dlg2.ui.comboBox.currentText()
        arc_end=self.dlg2.ui.comboBox_2.currentText()
        oriente=self.dlg2.ui.comboBox_3.currentText()
        poids=self.dlg2.ui.comboBox_4.currentText()
        ponderation=self.dlg2.ui.comboBox_5.currentText()
        global indicateur
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        global table
        table=[]
        if str(poids)=="non":
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=1
          table=table+[(attrsstart,attrsend,attrsdist)] 
         global G
         G=nx.Graph()
         if str(oriente)=="oui" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        if str(poids)=="oui":
         distind=provider.fieldNameIndex(str(ponderation))
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind,distind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=feat.attributes()[distind]
          table=table+[(attrsstart,attrsend,attrsdist)] 
         G=nx.Graph()
         if str(oriente)=="oui" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        if str(indicateur)=="Allongement moyen" and str(oriente)=="non" :
            spl=shortest_path_length(G, weight='weight')
            somme=0
            b=[0]
            self.dlg5 = testDialog5(self.iface.mainWindow())
            self.dlg5.ui.progressBar.setProperty("value", 0)
            self.dlg5.show()
            for l in range(len(G.nodes())):
                  somme=somme+sum(spl[l+1].values())
            for l in range(len(G.nodes())):
                  somme2=0
                  somme2b=0
                  somme3b=0
                  G2=0
                  G2=nx.Graph()
                  G2.add_weighted_edges_from(table)
                  edg=edges(G,l+1)
                  no=[0]
                  ct=0
                  for l2 in range(len(edg)):
                        dep=edg[l2][0]
                        arr=edg[l2][1]
                        G2.edge[dep][arr]['weight']=10000000000
                  spl2=shortest_path_length(G2, weight='weight')
                  for l2 in range(len(G.nodes())):
                        if l2!=l :
                              somme2=somme2+sum(spl2[l2+1].values())
                              if sum(spl2[l2+1].values())>= len(G.nodes())*10000000000 :
                                          no=no+[l2] 
                                          ct=ct+1
                        if l2==l :
                              somme3=somme-2*sum(spl[l2+1].values())
                              somme2= somme2-sum(spl2[l2+1].values())
                  if ct!=0:
                          for l2 in range(ct):
                                tp=spl2[no[l2+1]+1].values()
                                somme2b=somme2b-2*tp[l]+2*sum(spl2[no[l2+1]+1].values())
                                tp2=spl[no[l2+1]+1].values()
                                somme3b=somme3b+2*sum(spl[no[l2+1]+1].values())-2*tp2[l]
                  b=b+[somme2-somme2b-somme3+somme3b]
                  valbar=int(((l+1)/float(len(G.nodes())))*100)
                  self.dlg5.ui.progressBar.setProperty("value", valbar)
            self.dlg5.close() 
        if str(indicateur)=="Allongement moyen" and str(oriente)=="oui" :
                  QMessageBox.information(None, " message final : ", "Indicateur non developpe. Travaillez sur un graphe non oriente si possible.")
                  b=77777
        if str(indicateur)=="Centralite information" and str(poids)=="non" :
            b=closeness_vitality(G)
        if str(indicateur)=="Centralite information" and str(poids)=="oui":
            b=closeness_vitality(G, weight='weight')
        if str(indicateur)=="Dynamique" and str(poids)=="non" :
            nbalpha2, ok = QInputDialog.getText(None, "QInputDialog.getText()",  "Choisir le nombre de decimales de l\'indicateur (entre 2 et 5) :", QLineEdit.Normal, "2")
            nbalpha=int(nbalpha2)
            cen=betweenness_centrality(G)
            b=[0]+[0]*len(G.nodes())
            self.dlg5 = testDialog5(self.iface.mainWindow())
            self.dlg5.ui.progressBar.setProperty("value", 0)
            self.dlg5.show()
            for l in range(len(G.nodes())) :
                  if nbalpha==2:
                       alpha=0.01
                  if nbalpha==3:
                       alpha=0.001
                  if nbalpha==4:
                       alpha=0.0001
                  if nbalpha==5:
                      alpha=0.00001
                  destruction=len(G.nodes())
                  while destruction >= int(len(G.nodes())/2) :
                      G2=0
                      G2=nx.Graph()
                      G2.add_weighted_edges_from(table)
                      G2.remove_node(l+1)
                      temp=[0]*len(G.nodes())
                      cen2=betweenness_centrality(G2)
                      pile=[]
                      pilesave=[]
                      destruction=0
                      for k in cen2.keys() :  
                               temp[k-1]=cen2[k]-cen[k]
                               if temp[k-1]>alpha :
                                     pile=pile+[k]
                                     pilesave=pilesave+[k]
                                     destruction=destruction+1
                      while (len(pile) != 0) and (destruction<int(len(G.nodes())/2)) :
                                     G2.remove_node(pile[len(pile)-1])
                                     pile.remove(pile[len(pile)-1])
                                     cen2=betweenness_centrality(G2)
                                     for k2 in cen2.keys() :
                                                 temp[k2-1]=cen2[k2]-cen[k2]
                                                 if temp[k2-1]>alpha :
                                                     test=0
                                                     for t in pilesave :
                                                           if k2== t :
                                                                    test=1
                                                     if test==0 :
                                                         pile=pile+[k2]
                                                         pilesave=pilesave+[k2]
                                                         destruction=destruction+1
                      b[l+1]=alpha
                      valbar=int(((l+1)/float(len(G.nodes())))*100)
                      self.dlg5.ui.progressBar.setProperty("value", valbar)
                      if nbalpha==2:
                           alpha=0.01+alpha
                      if nbalpha==3:
                           alpha=0.001+alpha
                      if nbalpha==4:
                           alpha=0.0001+alpha
                      if nbalpha==5:
                           alpha=0.00001+alpha
            self.dlg5.close()
        if str(indicateur)=="Dynamique" and str(poids)=="oui":
            cen=betweenness_centrality(G,weight=True)
            b=[0]+[0]*len(G.nodes())
            self.dlg5 = testDialog5(self.iface.mainWindow())
            self.dlg5.ui.progressBar.setProperty("value", 0)
            self.dlg5.show()
            for l in range(len(G.nodes())) :
                  if nbalpha==2:
                       alpha=0.01
                  if nbalpha==3:
                       alpha=0.001
                  if nbalpha==4:
                       alpha=0.0001
                  if nbalpha==5:
                      alpha=0.00001
                  destruction=len(G.nodes())
                  while destruction >= int(len(G.nodes())/2) :
                      G2=0
                      G2=nx.Graph()
                      G2.add_weighted_edges_from(table)
                      G2.remove_node(l+1)
                      temp=[0]*len(G.nodes())
                      cen2=betweenness_centrality(G2,weight=True)
                      pile=[]
                      pilesave=[]
                      destruction=0
                      for k in cen2.keys() :  
                               temp[k-1]=cen2[k]-cen[k]
                               if temp[k-1]>alpha :
                                     pile=pile+[k]
                                     pilesave=pilesave+[k]
                                     destruction=destruction+1
                      while (len(pile) != 0) and (destruction<int(len(G.nodes())/2)) :
                                     G2.remove_node(pile[len(pile)-1])
                                     pile.remove(pile[len(pile)-1])
                                     cen2=betweenness_centrality(G2,weight=True)
                                     for k2 in cen2.keys() :
                                                 temp[k2-1]=cen2[k2]-cen[k2]
                                                 if temp[k2-1]>alpha :
                                                     test=0
                                                     for t in pilesave :
                                                           if k2== t :
                                                                    test=1
                                                     if test==0 :
                                                         pile=pile+[k2]
                                                         pilesave=pilesave+[k2]
                                                         destruction=destruction+1
                      #alpha=0.01+alpha
                      b[l+1]=alpha
                      valbar=int(((l+1)/float(len(G.nodes())))*100)
                      self.dlg5.ui.progressBar.setProperty("value", valbar)
                      if nbalpha==2:
                           alpha=0.01+alpha
                      if nbalpha==3:
                           alpha=0.001+alpha
                      if nbalpha==4:
                           alpha=0.0001+alpha
                      if nbalpha==5:
                           alpha=0.00001+alpha
            self.dlg5.close()
        if str(indicateur)=="Combinatoire":
                 self.dlg3 = testDialog3(self.iface.mainWindow())
                 self.dlg3.ui.lineEdit.setText("10")
                 self.dlg3.ui.lineEdit_2.setText("0.15")
                 self.dlg3.ui.lineEdit_6.setText("C:/Users/xxxxx/Desktop")
                 self.dlg3.ui.lineEdit_3.setText("test")
                 self.dlg3.ui.lineEdit_4.setText("10")
                 self.dlg3.ui.lineEdit_5.setText("7")
                 self.dlg3.ui.lineEdit_7.setText("7")
                 self.dlg3.ui.lineEdit_8.setText("2")
                 self.dlg3.ui.comboBox.addItems(["png","svg"])
                 QObject.connect(self.dlg3.ui.buttonBox, SIGNAL("accepted()"), self.calcul3)
                 self.dlg3.show()
        if str(indicateur)!="Combinatoire":
          if b!=77777:
            aLayer2 = allLayers[int(ind_noeud)]
            provider2 = aLayer2.dataProvider()
            nbcol=int(provider2.fields().count())
            provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
            aLayer2.startEditing()
            taille=len(G.nodes())
            for k in range(taille):
                  aLayer2.changeAttributeValue(k,nbcol,float(b[k+1]))
            aLayer2.commitChanges()

  def calcul3(self):
        if str(indicateur)=="Combinatoire":
                 self.dlg5 = testDialog5(self.iface.mainWindow())
                 self.dlg5.ui.progressBar.setProperty("value", 1)
                 self.dlg5.show()
                 format=self.dlg3.ui.comboBox.currentText()
                 nbal=self.dlg3.ui.lineEdit.text()
                 taux=self.dlg3.ui.lineEdit_2.text()
                 tx=double(taux)
                 nomfichier=self.dlg3.ui.lineEdit_3.text()
                 largeur=self.dlg3.ui.lineEdit_4.text()
                 hauteur=self.dlg3.ui.lineEdit_5.text()
                 rep=self.dlg3.ui.lineEdit_6.text()
                 pttaille=self.dlg3.ui.lineEdit_7.text()
                 lignelar=self.dlg3.ui.lineEdit_8.text()
                 nbal2=int(nbal)
                 G2=0
                 G3=0
                 G4=0
                 G4b=0
                 G2=nx.Graph()
                 G3=nx.Graph()
                 G4=nx.Graph()
                 G4b=nx.Graph()
                 #QMessageBox.information(None, " Message final : ", "l2"+str(table))
                 G2.add_weighted_edges_from(table)
                 G3.add_weighted_edges_from(table)
                 G4.add_weighted_edges_from(table)
                 G4b.add_weighted_edges_from(table)
                 #b=[0.00000]*(len(G.nodes())+1)
                 #b3=[0.00000]*(len(G.nodes())+1)
                 #b4=[0.00000]*(len(G.nodes())+1)
                 b=[1.00000]*(len(G.nodes())+1)
                 b3=[1.00000]*(len(G.nodes())+1)
                 b4=[1.00000]*(len(G.nodes())+1)
                 cen=betweenness_centrality(G,weight=True)
                 cens=sorted(cen.items(), reverse=True, key=operator.itemgetter(1))
                 cen3=degree(G)
                 cens3=sorted(cen3.items(), reverse=True, key=operator.itemgetter(1))
                 cen4=betweenness_centrality(G,weight=True)
                 cens4=sorted(cen4.items(), reverse=True, key=operator.itemgetter(1))
                 #for l in range(len(G.nodes())) :
                 for l in range(int((len(G.nodes()))*tx)) :
                          nbconnex=0
                          it=cens[l][0]
                          edg=edges(G,it)
                          for l2 in range(len(edg)): 
                                    dep=edg[l2][0]
                                    arr=edg[l2][1]
                                    G2.edge[dep][arr]['weight']=10000000000
                          spl2=shortest_path_length(G2, weight='weight')
                          #QMessageBox.information(None, " Message final : ", "l2"+str(l))
                          #fichier = open("C:/Users/serge.lhomme/Desktop/res.txt", "w")
                          #fichier.write(str(spl2))
                          #fichier.close()
                          nbconnex3=0
                          it3=cens3[l][0]
                          edg3=edges(G,it3)
                          for l2 in range(len(edg3)): 
                                    dep=edg3[l2][0]
                                    arr=edg3[l2][1]
                                    G3.edge[dep][arr]['weight']=10000000000
                          spl3=shortest_path_length(G3, weight='weight')
                          nbconnex4=0
                          it4=cens4[0][0]  
                          edg4=edges(G,it4)
                          for l2 in range(len(edg4)): 
                                    dep=edg4[l2][0]
                                    arr=edg4[l2][1]
                                    G4.edge[dep][arr]['weight']=10000000000
                          spl4=shortest_path_length(G4, weight='weight')
                          for l2 in range(len(G.nodes())):
                                   #QMessageBox.information(None, " Message final : ", "l2"+str(l2))
                                   ligne=spl2[l2+1].values()
                                   ligne3=spl3[l2+1].values()
                                   ligne4=spl4[l2+1].values()
                                   for l3 in range(len(G.nodes())):
                                            #QMessageBox.information(None, " Message final : ", "l3"+str(ligne))
                                            val=ligne[l3]
                                            val3=ligne3[l3]
                                            val4=ligne4[l3]
                                            if val >=10000000000 :
                                                  nbconnex=nbconnex+1
                                            if val3 >=10000000000 :
                                                  nbconnex3=nbconnex3+1
                                            if val4 >=10000000000 :
                                                  nbconnex4=nbconnex4+1
                          b[int(it)]=nbconnex/float((len(G.nodes())*(len(G.nodes())-1)))
                          b3[int(it3)]=nbconnex3/float((len(G.nodes())*(len(G.nodes())-1)))
                          b4[int(it4)]=nbconnex4/float((len(G.nodes())*(len(G.nodes())-1)))
                          G4b.remove_node(it4)
                          cen4=betweenness_centrality(G4b,weight=True)
                          cens4=sorted(cen4.items(), reverse=True, key=operator.itemgetter(1))
                          valbar=int(((3*(l+1))*100)/float((len(G.nodes())*(3+nbal2))))
                          self.dlg5.ui.progressBar.setProperty("value", valbar)
                 #b5tot=[0.00000]*(len(G.nodes())+1)
                 b5tot=[1.00000]*(len(G.nodes())+1)
                 for m in range(nbal2) :
                      G5=0
                      G5=nx.Graph()
                      b5=[0.00000]*(len(G.nodes())+1)
                      G5.add_weighted_edges_from(table)
                      cens5= G.nodes()
                      random.shuffle(cens5)
                      #for l in range(len(G.nodes())) :
                      #for l in range(2) :
                      for l in range(int((len(G.nodes()))*tx)) :
                          nbconnex5=0
                          it5=cens5[l]
                          edg5=edges(G,it5)
                          for l2 in range(len(edg5)):
                                    dep=edg5[l2][0]
                                    arr=edg5[l2][1]
                                    G5.edge[dep][arr]['weight']=10000000000
                          spl5=shortest_path_length(G5, weight='weight')
                          for l2 in range(len(G.nodes())):
                                   ligne5=spl5[l2+1].values()
                                   for l3 in range(len(G.nodes())):
                                            val5=ligne5[l3]
                                            if val5 >=10000000000 :
                                                  nbconnex5=nbconnex5+1
                          #b5[int(it5)]=nbconnex5
                          b5[l]=nbconnex5
                          valbar=int((((3*len(G.nodes()))+(l+1)+(m*len(G.nodes())))*100)/float((len(G.nodes())*(3+nbal2))))
                          self.dlg5.ui.progressBar.setProperty("value", valbar)
                      #b5tot=array(b5tot)+array(sorted(b5))
                      b5tot=array(b5tot)+array(b5)
                 b5tot= b5tot/float((len(G.nodes())*(len(G.nodes())-1)*nbal2))
                 taille=len(G.nodes())
                 self.dlg5.close()
                 lar=int(largeur)
                 ht=int(hauteur)
                 pttaille2=int(pttaille)
                 lignelar2=int(lignelar)
                 fig = plt.figure(figsize=(lar, ht))
                 p1, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), sorted(b[1:len(G.nodes())+1])[0:int((len(G.nodes())+1)*tx)], 'r', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 p2, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), sorted(b3[1:len(G.nodes())+1])[0:int((len(G.nodes())+1)*tx)], color='#00bfbf', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 p3, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), sorted(b4[1:len(G.nodes())+1])[0:int((len(G.nodes())+1)*tx)], color='#dbc71c', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 p4, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), b5tot[0:len(G.nodes())][0:int((len(G.nodes())+1)*tx)], color = '#51d51d', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 plt.ylabel('Perte de connectivite')
                 plt.xlabel('Poucentage de composants perturbes')
                 plt.legend([p4, p3, p2, p1], ["Aleatoire","Centralite dynamique", "Degre", "Centralite"], loc=2)
                 adresse=str(rep)+"/"+str(nomfichier)+"."+str(format)
                 plt.savefig(adresse, transparent = True)
                 plt.close()
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<img src="'+adresse+'">'
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()

  def runc(self): 
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table_noeud
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        self.dlg.ui.comboBox_2.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculc)
        self.dlg.show()

  def calculc(self):
        table_noeud=self.dlg.ui.comboBox.currentText()
        global table_arc
        table_arc=self.dlg.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2b(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_3.addItems(["non","oui"])
        self.dlg2.ui.comboBox_4.addItems(["non","oui"])
        self.dlg2.ui.comboBox_5.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Louvain method"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2c)
        self.dlg2.show()

  def calcul2c(self):
        arc_start=self.dlg2.ui.comboBox.currentText()
        arc_end=self.dlg2.ui.comboBox_2.currentText()
        oriente=self.dlg2.ui.comboBox_3.currentText()
        poids=self.dlg2.ui.comboBox_4.currentText()
        ponderation=self.dlg2.ui.comboBox_5.currentText()
        global indicateur
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        table=[]
        nbelement=0
        if str(poids)=="non":
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          nbelement= nbelement+1
          table=table+[(attrsstart,attrsend)] 
         G=nx.Graph()
         if str(oriente)=="oui" :
          G=nx.DiGraph()
         G.add_edges_from(table)
        if str(poids)=="oui":
         distind=provider.fieldNameIndex(str(ponderation))
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind,distind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=feat.attributes()[distind]
          nbelement= nbelement+1
          table=table+[(attrsstart,attrsend,attrsdist)] 
         G=nx.Graph()
         if str(oriente)=="oui" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        part = com.best_partition(G)
        aLayer2 = allLayers[int(ind_noeud)]
        provider2 = aLayer2.dataProvider()
        nbcol=int(provider2.fields().count())
        provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
        aLayer2.startEditing()
        taille=len(G.nodes())
        for k in range(taille):
              aLayer2.changeAttributeValue(k,nbcol,float(part[k+1]))
        aLayer2.commitChanges()
        mod= com.modularity(part,G)
        QMessageBox.information(None, " Message final : ", "La modularite est de  : "+str(mod))
