# -*- coding: utf-8 -*-
#-----------------------------------------------------------
#
# NetworkAnalysis
# Copyright Serge Lhomme
# EMAIL: serge.lhomme (at) u-pec.fr
# WEB  : http://serge.lhomme.pagesperso-orange.fr/deven.html
#
# Tools for analyzing networks characteristics
#
#-----------------------------------------------------------
#
# licensed under the terms of GNU GPL 2
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
#---------------------------------------------------------------------

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from PyQt4 import QtXml
from qgis.gui import *
import os
import sys
currentPath = os.path.dirname(__file__)
sys.path.append(os.path.abspath(os.path.dirname(__file__) + '/tools'))
import os
import community
import community as com
import networkx
import networkx as nx
from networkx import *
from testdialog import testDialog
from testdialog2 import testDialog2
from testdialog2b import testDialog2b
from testdialog3 import testDialog3
from testdialog4 import testDialog4
from testdialog5 import testDialog5
from testdialogtool import testDialogtool
from testdialogtoolb import testDialogtoolb
from testdialogtool2 import testDialogtool2
from testdialogtoolTTP import testDialogtoolTTP
from testdialogtoolID import testDialogtoolID
import operator
import numpy as np
import matplotlib.pyplot as plt
import random
import itertools as iter
from numpy import *
import csv
import processing
import string

class NetworkAnalysis:

  def __init__(self, iface):
    self.iface = iface

  def initGui(self):
    self.action = QAction("Basic Analysis", self.iface.mainWindow())
    QObject.connect(self.action, SIGNAL("activated()"), self.run)
    self.actionb = QAction("Vulnerability Analysis", self.iface.mainWindow())
    QObject.connect(self.actionb, SIGNAL("activated()"), self.runb)
    self.actionc = QAction("Community Detection", self.iface.mainWindow())
    QObject.connect(self.actionc, SIGNAL("activated()"), self.runc)
    self.actiond = QAction("Network Optimization", self.iface.mainWindow())
    QObject.connect(self.actiond, SIGNAL("activated()"), self.rund)
    self.actionf = QAction("Tools", self.iface.mainWindow())
    QObject.connect(self.actionf, SIGNAL("activated()"), self.runf)

    self.iface.addPluginToMenu("&Network Analysis...", self.action)
    self.iface.addPluginToMenu("&Network Analysis...", self.actionb)
    self.iface.addPluginToMenu("&Network Analysis...", self.actionc)
    self.iface.addPluginToMenu("&Network Analysis...", self.actiond)
    self.iface.addPluginToMenu("&Network Analysis...", self.actionf)

  def unload(self):
    self.iface.removePluginMenu("&Network Analysis...",self.action)
    self.iface.removePluginMenu("&Network Analysis...",self.actionb)
    self.iface.removePluginMenu("&Network Analysis...",self.actionc)
    self.iface.removePluginMenu("&Network Analysis...",self.actiond)
    self.iface.removePluginMenu("&Network Analysis...",self.actionf)
  #----------------------------------------------------------------------------------------------------------------------------------------                 Basic Analysis             ----------------------------------------------------------------------------------------------------------------------------------- 
  def run(self): 
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table_noeud
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        self.dlg.ui.comboBox_2.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calcul)
        self.dlg.show()

  def calcul(self):
        table_noeud=self.dlg.ui.comboBox.currentText()
        table_arc=self.dlg.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_3.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_4.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_5.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Degree","Closeness","Fareness","Betweenness","Clustering","Eigenvector", "Square_clustering", "Eccentricity", "Page_rank", "Average_neighbor_degree", "Hub_dependence", "Closeness_vitality"])  
        self.dlg2.ui.comboBox_7.addItems(["Yes","No"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2)
        self.dlg2.show()

  def calcul2(self):
        arc_start=self.dlg2.ui.comboBox.currentText()
        arc_end=self.dlg2.ui.comboBox_2.currentText()
        oriente=self.dlg2.ui.comboBox_3.currentText()
        poids=self.dlg2.ui.comboBox_4.currentText()
        ponderation=self.dlg2.ui.comboBox_5.currentText()
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        norm=self.dlg2.ui.comboBox_7.currentText()
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        table=[]
        if str(poids)=="No":
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          table=table+[(attrsstart,attrsend)] 
         G=nx.Graph()
         if str(oriente)=="Yes" :
          G=nx.DiGraph()
         G.add_edges_from(table)
        if str(poids)=="Yes":
         distind=provider.fieldNameIndex(str(ponderation))
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind,distind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=feat.attributes()[distind]
          table=table+[(attrsstart,attrsend,attrsdist)] 
         G=nx.Graph()
         if str(oriente)=="Yes" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        t=number_of_nodes(G)
        if str(indicateur)=="Betweenness" and str(poids)=="No" and str(norm)=="No" :
            b=betweenness_centrality(G,normalized=False)
        if str(indicateur)=="Betweenness" and str(poids)=="Yes" and str(norm)=="No" :
            b=betweenness_centrality(G, normalized=False, weight='weight')
        if str(indicateur)=="Betweenness" and str(poids)=="No" and str(norm)=="Yes" :
            b=betweenness_centrality(G)
        if str(indicateur)=="Betweenness" and str(poids)=="Yes" and str(norm)=="Yes" :
            b=betweenness_centrality(G,weight='weight')
        if str(indicateur)=="Eigenvector" and str(oriente)=="No" and str(norm)=="Yes" :
            b=eigenvector_centrality(G)
        if str(indicateur)=="Eigenvector" and str(oriente)=="Yes" and str(norm)=="Yes" :
            b=eigenvector_centrality(G)
            G2=reverse(G, copy=True)
            b2=eigenvector_centrality(G2)
        if str(indicateur)=="Eigenvector" and str(norm)=="No" :
            QMessageBox.information(None, " Message : ", "Eigenvector need to be normalized.")
            b=77777
        if str(indicateur)=="Closeness" and str(poids)=="No" and str(norm)=="No":
            b=closeness_centrality(G, normalized=False)
        if str(indicateur)=="Closeness" and str(poids)=="Yes" and str(norm)=="No":
            b=closeness_centrality(G, normalized=False, distance='weight')
        if str(indicateur)=="Closeness" and str(poids)=="No" and str(norm)=="Yes":
            b=closeness_centrality(G)
        if str(indicateur)=="Closeness" and str(poids)=="Yes" and str(norm)=="Yes":
            b=closeness_centrality(G,distance='weight')
        if str(indicateur)=="Clustering" and str(poids)=="No" and str(oriente)=="No" and str(norm)=="Yes":
            b=clustering(G)
        if str(indicateur)=="Clustering" and str(poids)=="Yes" and str(oriente)=="No" and str(norm)=="Yes":
            b=clustering(G, weight='weight')
        if str(indicateur)=="Clustering" and str(oriente)=="Yes":
            QMessageBox.information(None, " Message : ", "Here, edges need to be undirected.")
            b=77777
        if str(indicateur)=="Clustering" and str(norm)=="No":
            QMessageBox.information(None, " Message : ", "Clustering coefficient indices need to be normalized.")
            b=77777
        if str(indicateur)=="Square_clustering" and str(poids)=="No" and str(oriente)=="No" and str(norm)=="Yes":
            b=square_clustering(G)
        if str(indicateur)=="Square_clustering" and str(poids)=="Yes" and str(oriente)=="No" and str(norm)=="Yes":
            QMessageBox.information(None, " Message : ", "Need to be implemented.")
            b=77777
        if str(indicateur)=="Square_clustering" and str(oriente)=="Yes":
            QMessageBox.information(None, " Message : ", "Graph needs to be undirected.")
            b=77777
        if str(indicateur)=="Square_clustering" and str(norm)=="No":
            QMessageBox.information(None, " Message : ", "Square clustering coefficient needs to be normalized.")
            b=77777
        if str(indicateur)=="Eccentricity" and str(norm)=="Yes":
            QMessageBox.information(None, " Message : ", "Try with no normalization.")
            b=77777
        if str(indicateur)=="Eccentricity" and str(norm)=="No" and str(poids)=="No":
            spl=shortest_path_length(G)
            try:
                 b=eccentricity(G, sp=spl)
            except nx.NetworkXError as e:
                 b=77777
                 QMessageBox.information(None, " Message : ", "Error : " + str(e))
        if str(indicateur)=="Eccentricity" and str(norm)=="No" and str(poids)=="Yes":
            spl=shortest_path_length(G, weight='weight')
            try :
                 b=eccentricity(G, sp=spl)
            except nx.NetworkXError as e:
                 b=77777
                 QMessageBox.information(None, " Message : ", "Error : " + str(e))
        if str(indicateur)=="Page_rank" and str(poids)=="No" and str(norm)=="Yes":
            b=pagerank(G)
        if str(indicateur)=="Page_rank" and str(poids)=="Yes" and str(norm)=="Yes":
            b=pagerank(G, weight='weight')
        if str(indicateur)=="Page_rank" and str(norm)=="No":
            QMessageBox.information(None, " Message : ", "Page rank indices need to be normalized.")
            b=77777
        if str(indicateur)=="Average_neighbor_degree" and str(poids)=="No" and str(norm)=="No":
            b=average_neighbor_degree(G)
        if str(indicateur)=="Average_neighbor_degree" and str(poids)=="Yes" and str(norm)=="No":
            b=average_neighbor_degree(G, weight='weight')
        if str(indicateur)=="Average_neighbor_degree" and str(norm)=="Yes":
            QMessageBox.information(None, " Message : ", "Average neighbor degree indices can not be normalized.")
            b=77777
        if str(indicateur)=="Hub_dependence" and str(oriente)=="No" and str(norm)=="Yes" and str(poids)=="Yes":
            t=number_of_nodes(G)
            b=[0]*(t+1)
            for j in range(t):
               num=j+1
               listarc=G.edges(int(num),data=True)
               b2=[0]*(t+1)
               tot=0
               for i in range(len(listarc)):
                    w=listarc[i][2]
                    w2=w['weight']
                    b2[listarc[i][0]]=b2[listarc[i][0]]+w2
                    b2[listarc[i][1]]=b2[listarc[i][1]]+w2
                    tot=tot+w2
               b3=sorted(b2)
               if b3[t]!=0:
                  cal=b3[t-1]/float(b3[t])
               if b3[t]==0:
                  cal=NULL
               b2=[0]*(t+1)
               b[num]=cal
        if str(indicateur)=="Hub_dependence" and str(oriente)=="Yes" and str(norm)=="Yes" and str(poids)=="Yes":
            b=[0]*(t+1)
            bbb=[0]*(t+1)
            for j in range(t):
               num=j+1
               listarcout=G.out_edges(int(num),data=True)
               b2=[0]*(t+1)
               tot=0
               for i in range(len(listarcout)):
                    w=listarcout[i][2]
                    w2=w['weight']
                    b2[listarcout[i][0]]=b2[listarcout[i][0]]+w2
                    b2[listarcout[i][1]]=b2[listarcout[i][1]]+w2
                    tot=tot+w2
               b3=sorted(b2)
               if b3[t]!=0:
                  cal=b3[t-1]/float(b3[t])
               if b3[t]==0:
                  cal=NULL
               b2=[0]*(t+1)
               b[num]=cal
            for j in range(t):
               num=j+1
               listarcin=G.in_edges(int(num),data=True)
               b2=[0]*(t+1)
               tot=0
               for i in range(len(listarcin)):
                    w=listarcin[i][2]
                    w2=w['weight']
                    b2[listarcin[i][0]]=b2[listarcin[i][0]]+w2
                    b2[listarcin[i][1]]=b2[listarcin[i][1]]+w2
                    tot=tot+w2
               b3=sorted(b2)
               if b3[t]!=0:
                  cal=b3[t-1]/float(b3[t])
               if b3[t]==0:
                  cal=NULL
               b2=[0]*(t+1)
               bbb[num]=cal
            indicateur="Out_Hub_dependence"
        if str(indicateur)=="Hub_dependence" and str(norm)=="No":
            QMessageBox.information(None, " Message : ", "Hub dependence indices need to be normalized.")
            b=77777
        if str(indicateur)=="Hub_dependence" and str(poids)=="No":
            QMessageBox.information(None, " Message : ", "Weighted graph is necessary.")
            b=77777
        if str(indicateur)=="Closeness_vitality" and str(poids)=="No" and str(norm)=="No":
            b=closeness_vitality(G)
        if str(indicateur)=="Closeness_vitality" and str(poids)=="Yes" and str(norm)=="No":
            b=closeness_vitality(G, weight='weight')
        if str(indicateur)=="Closeness_vitality" and str(norm)=="Yes":
            QMessageBox.information(None, " Message : ", "No normalization for closeness vitality.")	
            b=77777
        if str(indicateur)=="Fareness" and str(poids)=="No" and str(norm)=="No":
            spl=shortest_path_length(G)
            b2=[0]*len(G.nodes())
            try:
              for i in range(len(G.nodes())):
                 for j in range(len(G.nodes())):
                     b2[i]=b2[i]+(spl[i+1][j+1]/(2*(float(t)-1)))
                     b2[j]=b2[j]+(spl[i+1][j+1]/(2*(float(t)-1)))
              err=0
            except :
                 QMessageBox.information(None, " Message : ","Graph not connected: infinite path length")
                 err=1
            b=77777
        if str(indicateur)=="Fareness" and str(poids)=="Yes" and str(norm)=="No":
            spl=shortest_path_length(G, weight='weight')
            b2=[0]*len(G.nodes())
            try:
              for i in range(len(G.nodes())):
                 for j in range(len(G.nodes())):
                     b2[i]=b2[i]+(spl[i+1][j+1]/(2*(float(t)-1)))
                     b2[j]=b2[j]+(spl[i+1][j+1]/(2*(float(t)-1)))
              err=0
            except :
                 QMessageBox.information(None, " Message : ","Graph not connected: infinite path length")
                 err=1
            b=77777
        if str(indicateur)=="Fareness" and str(norm)=="Yes":
            QMessageBox.information(None, " Message : ", "No normalization for fareness.")
            b=77777
        if str(indicateur)=="Degree" and str(norm)=="No" and str(oriente)=="No" and str(poids)=="No":
            b=G.degree()
        if str(indicateur)=="Degree" and str(norm)=="No" and str(oriente)=="No" and str(poids)=="Yes":
            b=G.degree(weight='weight')
        if str(indicateur)=="Degree" and str(norm)=="Yes" and str(oriente)=="No" and str(poids)=="No":
            b=degree_centrality(G)
        if str(indicateur)=="Degree" and str(norm)=="Yes" and str(oriente)=="No" and str(poids)=="Yes":
            QMessageBox.information(None, " Message : ", "No implementing  in this version")
            b=77777
        if str(indicateur)=="Degree" and str(norm)=="Yes" and str(oriente)=="Yes":
            QMessageBox.information(None, " Message : ", "No normalization for degree if graph is oriented.")
            b=77777
        if str(indicateur)=="Degree" and str(norm)=="No" and str(oriente)=="Yes" and str(poids)=="Yes":
            b=G.degree(weight='weight')
            b2=G.out_degree(weight='weight')
            b3=G.in_degree(weight='weight')
        if str(indicateur)=="Degree" and str(norm)=="No" and str(oriente)=="Yes" and str(poids)=="No":
            b=G.degree()
            b2=G.out_degree()
            b3=G.in_degree()
        if b!=77777 :
         taille=t
         aLayer2 = allLayers[int(ind_noeud)]
         provider2 = aLayer2.dataProvider()
         nbcol=int(provider2.fields().count())
         provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
         aLayer2.startEditing()
         for k in range(taille):
           aLayer2.changeAttributeValue(k,nbcol,b[k+1])
         aLayer2.commitChanges()
        if str(indicateur)=="Fareness" and str(norm)=="No" :
         if err==0: 
          taille=t
          aLayer2 = allLayers[int(ind_noeud)]
          provider2 = aLayer2.dataProvider()
          nbcol=int(provider2.fields().count())
          provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
          aLayer2.startEditing()
          for k in range(taille):
            aLayer2.changeAttributeValue(k,nbcol,float(b2[k]))
          aLayer2.commitChanges()
        if str(indicateur)=="Out_Hub_dependence":
         taille=t
         aLayer2 = allLayers[int(ind_noeud)]
         provider2 = aLayer2.dataProvider()
         nbcol=int(provider2.fields().count())
         provider2.addAttributes([QgsField("In_Hub_dependence", QVariant.Double)])
         aLayer2.startEditing()
         for k in range(taille):
           aLayer2.changeAttributeValue(k,nbcol,bbb[k+1])
         aLayer2.commitChanges()
        if str(indicateur)=="Eigenvector" and str(oriente)=="Yes" :
         taille=len(b)
         aLayer2 = allLayers[int(ind_noeud)]
         provider2 = aLayer2.dataProvider()
         nbcol=int(provider2.fields().count())
         provider2.addAttributes([QgsField("Left_Eigenvector", QVariant.Double)])
         aLayer2.startEditing()
         for k in range(taille):
           aLayer2.changeAttributeValue(k,nbcol,float(b2[k+1]))
         aLayer2.commitChanges()
        if str(indicateur)=="Degree" and str(norm)=="No" and str(oriente)=="Yes":
             taille=len(b)
             aLayer2 = allLayers[int(ind_noeud)]
             provider2 = aLayer2.dataProvider()
             provider2.addAttributes([QgsField("out_degree", QVariant.Double)])
             aLayer2.startEditing()
             for k in range(taille):
                 aLayer2.changeAttributeValue(k,nbcol+1,b2[k+1])
             aLayer2.commitChanges() 
             taille=len(b)
             aLayer2 = allLayers[int(ind_noeud)]
             provider2 = aLayer2.dataProvider()
             provider2.addAttributes([QgsField("in_degree", QVariant.Double)])
             aLayer2.startEditing()
             for k in range(taille):
                 aLayer2.changeAttributeValue(k,nbcol+2,b3[k+1])
             aLayer2.commitChanges() 
        QMessageBox.information(None, " Message : ", "End")
  #----------------------------------------------------------------------------------------------------------------------------------------                Vulnerability Analysis             -----------------------------------------------------------------------------------------------------------------------------------
  def runb(self): 
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table_noeud
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        self.dlg.ui.comboBox_2.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculb)
        self.dlg.show()

  def calculb(self):
        table_noeud=self.dlg.ui.comboBox.currentText()
        global table_arc
        table_arc=self.dlg.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2b(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_3.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_4.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_5.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Fareness_increase","Closeness_vitality","Dynamic_analysis","Error_attack"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2b)
        self.dlg2.show()

  def calcul2b(self):
        arc_start=self.dlg2.ui.comboBox.currentText()
        arc_end=self.dlg2.ui.comboBox_2.currentText()
        oriente=self.dlg2.ui.comboBox_3.currentText()
        poids=self.dlg2.ui.comboBox_4.currentText()
        ponderation=self.dlg2.ui.comboBox_5.currentText()
        global indicateur
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        global table
        table=[]
        if str(poids)=="No":
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=1
          table=table+[(attrsstart,attrsend,attrsdist)] 
         global G
         G=nx.Graph()
         if str(oriente)=="Yes" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        if str(poids)=="Yes":
         distind=provider.fieldNameIndex(str(ponderation))
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind,distind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=feat.attributes()[distind]
          table=table+[(attrsstart,attrsend,attrsdist)] 
         G=nx.Graph()
         if str(oriente)=="Yes" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        if str(indicateur)=="Fareness_increase":
            spl=shortest_path_length(G, weight='weight')
            self.dlg5 = testDialog5(self.iface.mainWindow())
            self.dlg5.ui.progressBar.setProperty("value", 0)
            self.dlg5.show()
            b2pro=[0]*len(G.nodes())
            b=[0]*(len(G.nodes())+1)
            tot=0
            try :
                 for i in range(len(G.nodes())):
                     for j in range(len(G.nodes())):
                         b2pro[i]=b2pro[i]+(spl[i+1][j+1])
                         b2pro[j]=b2pro[j]+(spl[i+1][j+1])
                         tot=tot+spl[i+1][j+1]
                 err=0
            except :
                 QMessageBox.information(None, " Message : ", "Graph not connected: infinite path length.")
                 err=1
                 b=77777
            if err==0:
                 for l in range(len(G.nodes())):
                     G2=0
                     G2=nx.Graph()
                     if str(oriente)=="Yes" :
                         G2=nx.DiGraph()
                     G2.add_weighted_edges_from(table)
                     edg=nx.edges(G,l+1)
                     for l2 in range(len(edg)):
                         dep=edg[l2][0]
                         arr=edg[l2][1]
                         G2.edge[dep][arr]['weight']=10000000000000
                     spl2=nx.shortest_path_length(G2, weight='weight')
                     totper=0
                     for l2 in range(len(G.nodes())):
                         for l3 in range(len(G.nodes())):
                             if l2!=l:
                                 if l3!=l:
                                     totper=totper+spl2[l2+1][l3+1]
                     res=totper-(tot-b2pro[l])
                     if res<10000000000000 :
                         b[l+1]=res
                     if res>=10000000000000 :
                         QMessageBox.information(None, " Message : ", "Be careful, removed the node "+str(l+1)+" induces infinite distances : fareness increase = 9999999999999999")
                         b[l+1]=9999999999999999
                     valbar=int(((l+1)/float(len(G.nodes())))*100)
                     self.dlg5.ui.progressBar.setProperty("value", valbar)
            self.dlg5.close() 
        if str(indicateur)=="Closeness_vitality" and str(poids)=="No" :
            b=closeness_vitality(G)
        if str(indicateur)=="Closeness_vitality" and str(poids)=="Yes":
            b=closeness_vitality(G, weight='weight')
        if str(indicateur)=="Dynamic_analysis" and str(poids)=="No" and str(oriente)=="No":
            nbalpha2, ok = QInputDialog.getText(None, "QInputDialog.getText()",  "Decimal number (between 2 and 5) :", QLineEdit.Normal, "2")
            nbalpha=int(nbalpha2)
            cen=betweenness_centrality(G)
            b=[0]+[0]*len(G.nodes())
            self.dlg5 = testDialog5(self.iface.mainWindow())
            self.dlg5.ui.progressBar.setProperty("value", 0)
            self.dlg5.show()
            for l in range(len(G.nodes())) :
                  if nbalpha==2:
                       alpha=0.01
                  if nbalpha==3:
                       alpha=0.001
                  if nbalpha==4:
                       alpha=0.0001
                  if nbalpha==5:
                      alpha=0.00001
                  destruction=len(G.nodes())
                  while destruction >= int(len(G.nodes())/2) :
                      G2=0
                      G2=nx.Graph()
                      G2.add_weighted_edges_from(table)
                      G2.remove_node(l+1)
                      temp=[0]*len(G.nodes())
                      cen2=betweenness_centrality(G2)
                      pile=[]
                      pilesave=[]
                      destruction=0
                      for k in cen2.keys() :  
                               temp[k-1]=cen2[k]-cen[k]
                               if temp[k-1]>alpha :
                                     pile=pile+[k]
                                     pilesave=pilesave+[k]
                                     destruction=destruction+1
                      while (len(pile) != 0) and (destruction<int(len(G.nodes())/2)) :
                                     G2.remove_node(pile[len(pile)-1])
                                     pile.remove(pile[len(pile)-1])
                                     cen2=betweenness_centrality(G2)
                                     for k2 in cen2.keys() :
                                                 temp[k2-1]=cen2[k2]-cen[k2]
                                                 if temp[k2-1]>alpha :
                                                     test=0
                                                     for t in pilesave :
                                                           if k2== t :
                                                                    test=1
                                                     if test==0 :
                                                         pile=pile+[k2]
                                                         pilesave=pilesave+[k2]
                                                         destruction=destruction+1
                      b[l+1]=alpha
                      valbar=int(((l+1)/float(len(G.nodes())))*100)
                      self.dlg5.ui.progressBar.setProperty("value", valbar)
                      if nbalpha==2:
                           alpha=0.01+alpha
                      if nbalpha==3:
                           alpha=0.001+alpha
                      if nbalpha==4:
                           alpha=0.0001+alpha
                      if nbalpha==5:
                           alpha=0.00001+alpha
            self.dlg5.close()
        if str(indicateur)=="Dynamic_analysis" and str(poids)=="Yes" and str(oriente)=="No":
            cen=betweenness_centrality(G,weight=True)
            b=[0]+[0]*len(G.nodes())
            self.dlg5 = testDialog5(self.iface.mainWindow())
            self.dlg5.ui.progressBar.setProperty("value", 0)
            self.dlg5.show()
            for l in range(len(G.nodes())) :
                  if nbalpha==2:
                       alpha=0.01
                  if nbalpha==3:
                       alpha=0.001
                  if nbalpha==4:
                       alpha=0.0001
                  if nbalpha==5:
                      alpha=0.00001
                  destruction=len(G.nodes())
                  while destruction >= int(len(G.nodes())/2) :
                      G2=0
                      G2=nx.Graph()
                      G2.add_weighted_edges_from(table)
                      G2.remove_node(l+1)
                      temp=[0]*len(G.nodes())
                      cen2=betweenness_centrality(G2,weight=True)
                      pile=[]
                      pilesave=[]
                      destruction=0
                      for k in cen2.keys() :  
                               temp[k-1]=cen2[k]-cen[k]
                               if temp[k-1]>alpha :
                                     pile=pile+[k]
                                     pilesave=pilesave+[k]
                                     destruction=destruction+1
                      while (len(pile) != 0) and (destruction<int(len(G.nodes())/2)) :
                                     G2.remove_node(pile[len(pile)-1])
                                     pile.remove(pile[len(pile)-1])
                                     cen2=betweenness_centrality(G2,weight=True)
                                     for k2 in cen2.keys() :
                                                 temp[k2-1]=cen2[k2]-cen[k2]
                                                 if temp[k2-1]>alpha :
                                                     test=0
                                                     for t in pilesave :
                                                           if k2== t :
                                                                    test=1
                                                     if test==0 :
                                                         pile=pile+[k2]
                                                         pilesave=pilesave+[k2]
                                                         destruction=destruction+1
                      b[l+1]=alpha
                      valbar=int(((l+1)/float(len(G.nodes())))*100)
                      self.dlg5.ui.progressBar.setProperty("value", valbar)
                      if nbalpha==2:
                           alpha=0.01+alpha
                      if nbalpha==3:
                           alpha=0.001+alpha
                      if nbalpha==4:
                           alpha=0.0001+alpha
                      if nbalpha==5:
                           alpha=0.00001+alpha
            self.dlg5.close()
        if str(indicateur)=="Dynamic_analysis" and str(oriente)=="Yes":
             QMessageBox.information(None, " Message : ", "Currently Graph needs to be undirected.")
             b=77777
        if str(indicateur)=="Error_attack":
             if str(oriente)=="No":
                 self.dlg3 = testDialog3(self.iface.mainWindow())
                 self.dlg3.ui.lineEdit.setText("10")
                 self.dlg3.ui.lineEdit_2.setText("0.15")
                 #self.dlg3.ui.lineEdit_6.setText("C:/Users/xxxxx/Desktop")
                 self.dlg3.ui.lineEdit_6.setText("")
                 self.dlg3.ui.lineEdit_3.setText("test")
                 self.dlg3.ui.lineEdit_4.setText("10")
                 self.dlg3.ui.lineEdit_5.setText("7")
                 self.dlg3.ui.lineEdit_7.setText("7")
                 self.dlg3.ui.lineEdit_8.setText("2")
                 self.dlg3.ui.comboBox.addItems(["tiff","svg","jpg"])
                 self.dlg3.ui.directoryButton.clicked.connect(self.openDir)
                 QObject.connect(self.dlg3.ui.buttonBox, SIGNAL("accepted()"), self.calcul3)
                 self.dlg3.show()
             if str(oriente)=="Yes":
                 QMessageBox.information(None, " Message : ", "Currently Graph needs to be undirected.")
                 b=77777
        if str(indicateur)!="Error_attack":
          if b!=77777:
            aLayer2 = allLayers[int(ind_noeud)]
            provider2 = aLayer2.dataProvider()
            nbcol=int(provider2.fields().count())
            provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
            aLayer2.startEditing()
            taille=len(G.nodes())
            for k in range(taille):
                  aLayer2.changeAttributeValue(k,nbcol,float(b[k+1]))
            aLayer2.commitChanges()
          QMessageBox.information(None, " Message : ", "End")

  def openDir(self):
        options = QFileDialog.DontResolveSymlinks | QFileDialog.ShowDirsOnly
        directory = QFileDialog.getExistingDirectory(None, "QFileDialog.getExistingDirectory()", self.dlg3.ui.lineEdit_6.text(), options)
        if directory:
            self.dlg3.ui.lineEdit_6.setText(directory)

  def calcul3(self):
        if str(indicateur)=="Error_attack":
                 self.dlg5 = testDialog5(self.iface.mainWindow())
                 self.dlg5.ui.progressBar.setProperty("value", 1)
                 self.dlg5.show()
                 format=self.dlg3.ui.comboBox.currentText()
                 nbal=self.dlg3.ui.lineEdit.text()
                 taux=self.dlg3.ui.lineEdit_2.text()
                 tx=double(taux)
                 nomfichier=self.dlg3.ui.lineEdit_3.text()
                 largeur=self.dlg3.ui.lineEdit_4.text()
                 hauteur=self.dlg3.ui.lineEdit_5.text()
                 rep=self.dlg3.ui.lineEdit_6.text()
                 pttaille=self.dlg3.ui.lineEdit_7.text()
                 lignelar=self.dlg3.ui.lineEdit_8.text()
                 nbal2=int(nbal)
                 G2=0
                 G3=0
                 G4=0
                 G4b=0
                 G2=nx.Graph()
                 G3=nx.Graph()
                 G4=nx.Graph()
                 G4b=nx.Graph()
                 G2.add_weighted_edges_from(table)
                 G3.add_weighted_edges_from(table)
                 G4.add_weighted_edges_from(table)
                 G4b.add_weighted_edges_from(table)
                 b=[1.00000]*(len(G.nodes())+1)
                 b3=[1.00000]*(len(G.nodes())+1)
                 b4=[1.00000]*(len(G.nodes())+1)
                 cen=betweenness_centrality(G,weight=True)
                 cens=sorted(cen.items(), reverse=True, key=operator.itemgetter(1))
                 cen3=degree(G)
                 cens3=sorted(cen3.items(), reverse=True, key=operator.itemgetter(1))
                 cen4=betweenness_centrality(G,weight=True)
                 cens4=sorted(cen4.items(), reverse=True, key=operator.itemgetter(1))
                 for l in range(int((len(G.nodes()))*tx)) :
                          nbconnex=0
                          it=cens[l][0]
                          edg=edges(G,it)
                          for l2 in range(len(edg)): 
                                    dep=edg[l2][0]
                                    arr=edg[l2][1]
                                    G2.edge[dep][arr]['weight']=10000000000
                          spl2=shortest_path_length(G2, weight='weight')
                          nbconnex3=0
                          it3=cens3[l][0]
                          edg3=edges(G,it3)
                          for l2 in range(len(edg3)): 
                                    dep=edg3[l2][0]
                                    arr=edg3[l2][1]
                                    G3.edge[dep][arr]['weight']=10000000000
                          spl3=shortest_path_length(G3, weight='weight')
                          nbconnex4=0
                          it4=cens4[0][0]  
                          edg4=edges(G,it4)
                          for l2 in range(len(edg4)): 
                                    dep=edg4[l2][0]
                                    arr=edg4[l2][1]
                                    G4.edge[dep][arr]['weight']=10000000000
                          spl4=shortest_path_length(G4, weight='weight')
                          for l2 in range(len(G.nodes())):
                                   ligne=spl2[l2+1].values()
                                   ligne3=spl3[l2+1].values()
                                   ligne4=spl4[l2+1].values()
                                   for l3 in range(len(G.nodes())):
                                            val=ligne[l3]
                                            val3=ligne3[l3]
                                            val4=ligne4[l3]
                                            if val >=10000000000 :
                                                  nbconnex=nbconnex+1
                                            if val3 >=10000000000 :
                                                  nbconnex3=nbconnex3+1
                                            if val4 >=10000000000 :
                                                  nbconnex4=nbconnex4+1
                          b[int(it)]=nbconnex/float((len(G.nodes())*(len(G.nodes())-1)))
                          b3[int(it3)]=nbconnex3/float((len(G.nodes())*(len(G.nodes())-1)))
                          b4[int(it4)]=nbconnex4/float((len(G.nodes())*(len(G.nodes())-1)))
                          G4b.remove_node(it4)
                          cen4=betweenness_centrality(G4b,weight=True)
                          cens4=sorted(cen4.items(), reverse=True, key=operator.itemgetter(1))
                          valbar=int(((3*(l+1))*100)/float((len(G.nodes())*(3+nbal2))))
                          self.dlg5.ui.progressBar.setProperty("value", valbar)
                 b5tot=[1.00000]*(len(G.nodes())+1)
                 for m in range(nbal2) :
                      G5=0
                      G5=nx.Graph()
                      b5=[0.00000]*(len(G.nodes())+1)
                      G5.add_weighted_edges_from(table)
                      cens5= G.nodes()
                      random.shuffle(cens5)
                      for l in range(int((len(G.nodes()))*tx)) :
                          nbconnex5=0
                          it5=cens5[l]
                          edg5=edges(G,it5)
                          for l2 in range(len(edg5)):
                                    dep=edg5[l2][0]
                                    arr=edg5[l2][1]
                                    G5.edge[dep][arr]['weight']=10000000000
                          spl5=shortest_path_length(G5, weight='weight')
                          for l2 in range(len(G.nodes())):
                                   ligne5=spl5[l2+1].values()
                                   for l3 in range(len(G.nodes())):
                                            val5=ligne5[l3]
                                            if val5 >=10000000000 :
                                                  nbconnex5=nbconnex5+1
                          b5[l]=nbconnex5
                          valbar=int((((3*len(G.nodes()))+(l+1)+(m*len(G.nodes())))*100)/float((len(G.nodes())*(3+nbal2))))
                          self.dlg5.ui.progressBar.setProperty("value", valbar)
                      b5tot=array(b5tot)+array(b5)
                 b5tot= b5tot/float((len(G.nodes())*(len(G.nodes())-1)*nbal2))
                 taille=len(G.nodes())
                 self.dlg5.close()
                 lar=int(largeur)
                 ht=int(hauteur)
                 pttaille2=int(pttaille)
                 lignelar2=int(lignelar)
                 fig = plt.figure(figsize=(lar, ht))
                 p1, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), sorted(b[1:len(G.nodes())+1])[0:int((len(G.nodes())+1)*tx)], 'r', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 p2, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), sorted(b3[1:len(G.nodes())+1])[0:int((len(G.nodes())+1)*tx)], color='#00bfbf', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 p3, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), sorted(b4[1:len(G.nodes())+1])[0:int((len(G.nodes())+1)*tx)], color='#dbc71c', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 p4, = plt.plot(100*array(G.nodes()[0:int((len(G.nodes())+1)*tx)])/float(int(len(G.nodes()))), b5tot[0:len(G.nodes())][0:int((len(G.nodes())+1)*tx)], color = '#51d51d', linewidth=lignelar2, marker='o', markersize=pttaille2)
                 plt.ylabel('Connectivity loss')
                 plt.xlabel('Fraction of nodes removed')
                 plt.legend([p4, p3, p2, p1], ["Random","Cascading", "Degree", "Betweenness"], loc=4)
                 #adresse=str(rep)+"/"+str(nomfichier)+"."+str(format)
                 adresse=str(rep)+"\\"+str(nomfichier)+"."+str(format)
                 plt.savefig(adresse)
                 plt.close()
                 self.dlg4 = testDialog4(self.iface.mainWindow())
                 texthtml='<img src="'+adresse+'">'
                 self.dlg4.ui.textBrowser.setHtml(texthtml)
                 self.dlg4.show()
  #----------------------------------------------------------------------------------------------------------------------------------------                 Community Detection             -----------------------------------------------------------------------------------------------------------------------------------
  def runc(self): 
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table_noeud
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        self.dlg.ui.comboBox_2.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculc)
        self.dlg.show()

  def calculc(self):
        table_noeud=self.dlg.ui.comboBox.currentText()
        global table_arc
        table_arc=self.dlg.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2b(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_3.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_4.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_5.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Louvain method"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2c)
        self.dlg2.show()

  def calcul2c(self):
        arc_start=self.dlg2.ui.comboBox.currentText()
        arc_end=self.dlg2.ui.comboBox_2.currentText()
        oriente=self.dlg2.ui.comboBox_3.currentText()
        poids=self.dlg2.ui.comboBox_4.currentText()
        ponderation=self.dlg2.ui.comboBox_5.currentText()
        global indicateur
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        table=[]
        nbelement=0
        if str(poids)=="No":
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          nbelement= nbelement+1
          table=table+[(attrsstart,attrsend)] 
         G=nx.Graph()
         G.add_edges_from(table)
         if str(oriente)=="Yes" :
             QMessageBox.information(None, " Message : ", "Graph needs to be undirected")   
        if str(poids)=="Yes":
         distind=provider.fieldNameIndex(str(ponderation))
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind,distind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=feat.attributes()[distind]
          nbelement= nbelement+1
          table=table+[(attrsstart,attrsend,attrsdist)] 
         G=nx.Graph()
         G.add_weighted_edges_from(table)
         if str(oriente)=="Yes" :
          QMessageBox.information(None, " Message : ", "Graph needs to be undirected")
        if str(oriente)=="No":
             part = com.best_partition(G)
             aLayer2 = allLayers[int(ind_noeud)]
             provider2 = aLayer2.dataProvider()
             nbcol=int(provider2.fields().count())
             provider2.addAttributes([QgsField(str(indicateur), QVariant.Double)])
             aLayer2.startEditing()
             taille=len(G.nodes())
             for k in range(taille):
                 aLayer2.changeAttributeValue(k,nbcol,float(part[k+1]))
             aLayer2.commitChanges()
             mod= com.modularity(part,G)
             QMessageBox.information(None, " Message : ", "Modularity : "+str(mod))
        QMessageBox.information(None, " Message : ", "End")
  #----------------------------------------------------------------------------------------------------------------------------------------                 Optimization             -----------------------------------------------------------------------------------------------------------------------------------
  def rund(self): 
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        global table_noeud
        self.dlg = testDialog(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(lay)
        self.dlg.ui.comboBox_2.addItems(lay)
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculd)
        self.dlg.show()

  def calculd(self):
        table_noeud=self.dlg.ui.comboBox.currentText()
        global table_arc
        table_arc=self.dlg.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        global aLayer2
        aLayer2 = allLayers[int(ind_noeud)]
        global provider2
        provider2 = aLayer2.dataProvider()
        fields=[]
        fields2=[""]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
          fields2=fields2+[str(field[i].name())]
        self.dlg2 = testDialog2b(self.iface.mainWindow())
        self.dlg2.ui.comboBox.addItems(fields)
        self.dlg2.ui.comboBox_2.addItems(fields)
        self.dlg2.ui.comboBox_3.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_4.addItems(["No","Yes"])
        self.dlg2.ui.comboBox_5.addItems(fields2)
        self.dlg2.ui.comboBox_6.addItems(["Delaunay", "Minimum Spanning Tree"])
        QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2d)
        self.dlg2.show()

  def calcul2d(self):
        arc_start=self.dlg2.ui.comboBox.currentText()
        arc_end=self.dlg2.ui.comboBox_2.currentText()
        oriente=self.dlg2.ui.comboBox_3.currentText()
        poids=self.dlg2.ui.comboBox_4.currentText()
        ponderation=self.dlg2.ui.comboBox_5.currentText()
        indicateur=self.dlg2.ui.comboBox_6.currentText()
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        table=[]
        geo=[]
        if str(poids)=="No":
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          geo = geo + [feat.geometry().asPolyline()]
          attrsdist=1
          table=table+[(attrsstart,attrsend,attrsdist)] 
         global G
         G=nx.Graph()
         if str(oriente)=="Yes" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        if str(poids)=="Yes":
         distind=provider.fieldNameIndex(str(ponderation))
         fit1 = provider.getFeatures( QgsFeatureRequest().setSubsetOfAttributes([startind,endind,distind]) )
         while fit1.nextFeature(feat):
          attrsstart=feat.attributes()[startind]
          attrsend=feat.attributes()[endind]
          attrsdist=feat.attributes()[distind]
          table=table+[(attrsstart,attrsend,attrsdist)] 
          geo = geo + [feat.geometry().asPolyline()]
         G=nx.Graph()
         if str(oriente)=="Yes" :
          G=nx.DiGraph()
         G.add_weighted_edges_from(table)
        t=number_of_nodes(G)
        if indicateur=="Delaunay":
            inp=str(aLayer2.source())
            inp2=inp.split('\\')
            out=""
            for i in range(len(inp2)-1):
			    out=out+str(inp2[i])+"/"
            out=out+"Delaunay.shp"
            a=processing.runalg('qgis:delaunaytriangulation', inp, out)
            delaunay=self.iface.addVectorLayer(out, "Delaunay", "ogr")
            provider3 = delaunay.dataProvider()
            feat = QgsFeature()
            tabledelaunay=[]
            fit1 = provider3.getFeatures()
            while fit1.nextFeature(feat):
                som1=feat.attributes()[0]
                som2=feat.attributes()[1]
                som3=feat.attributes()[2]
                geome=feat.geometry()
                geom=geome.asPolygon()
                x1=geom[0][0][0]
                y1=geom[0][0][1]
                x2=geom[0][1][0]
                y2=geom[0][1][1]
                x3=geom[0][2][0]
                y3=geom[0][2][1]
                tabledelaunay=tabledelaunay+[(som1+1,som2+1,x1,y1,x2,y2)] 
                tabledelaunay=tabledelaunay+[(som1+1,som3+1,x1,y1,x3,y3)] 
                tabledelaunay=tabledelaunay+[(som2+1,som3+1,x2,y2,x3,y3)] 
            epsg=canvas.mapRenderer().destinationCrs().authid()
            vl = QgsVectorLayer("LineString?crs="+str(epsg), "Delaunay", "memory")
            pr = vl.dataProvider()
            tabdelfin=[tabledelaunay[0]]
            point1=QgsPoint(tabledelaunay[0][2],tabledelaunay[0][3])
            point2=QgsPoint(tabledelaunay[0][4],tabledelaunay[0][5])
            fet = QgsFeature()
            fet.setGeometry( QgsGeometry.fromPolyline([point1,point2]) )
            pr.addFeatures( [ fet ] )
            vl.commitChanges()
            QgsMapLayerRegistry.instance().addMapLayer(vl)
            for i in range(len(tabledelaunay)):
                ligne=tabledelaunay[i]
                test=0
                for j in range(len(tabdelfin)): 
                    ligne2=tabdelfin[j]
                    if (ligne2[0]==ligne[0]) and (ligne2[1]==ligne[1]) :
                        test=1
                    if (ligne2[0]==ligne[1]) and (ligne2[1]==ligne[0]) :
                        test=1
                if test==0:
                    tabdelfin=tabdelfin+[ligne]
                    point1=QgsPoint(ligne[2],ligne[3])
                    point2=QgsPoint(ligne[4],ligne[5])
                    fet = QgsFeature()
                    fet.setGeometry( QgsGeometry.fromPolyline([point1,point2]) )
                    pr.addFeatures( [ fet ] )
                    vl.commitChanges()
            vl.startEditing()
            pr.addAttributes( [ QgsField("ID", QVariant.Int) ] )
            pr.addAttributes( [ QgsField("Start", QVariant.Int) ] )
            pr.addAttributes( [ QgsField("End", QVariant.Int) ] )
            vl.commitChanges()
            for i in range(len(tabdelfin)):
                vl.startEditing()
                vl.changeAttributeValue(i+1,0, int(i+1))
                vl.changeAttributeValue(i+1,1,int(tabdelfin[i][0]))
                vl.changeAttributeValue(i+1,2,int(tabdelfin[i][1]))
                vl.commitChanges()
        if indicateur=="Minimum Spanning Tree":
            if str(oriente)=="Yes" :
                QMessageBox.information(None, " Message : ", "Graph needs to be undirected")
            if str(oriente)=="No" :
                epsg=canvas.mapRenderer().destinationCrs().authid()
                v = QgsVectorLayer("LineString?crs=epsg:"+str(epsg), "MST", "memory")
                p = v.dataProvider()
                v.startEditing()
                p.addAttributes( [ QgsField("ID", QVariant.Int) ] )
                p.addAttributes( [ QgsField(arc_start, QVariant.Int) ] )
                p.addAttributes( [ QgsField(arc_end, QVariant.Int) ] )
                p.addAttributes( [ QgsField("ID_Net", QVariant.Int) ] )
                v.commitChanges()
                r = nx.minimum_spanning_tree(G)
                res = r.edges(data=True)
                id = 1
                for i in range(len(res)):
                    val=0
                    valsave = 0
                    for j in range(len(table)):
                        if (res[i][0] == table[j][0]) and (res[i][1] == table[j][1]) :
                            valsave = val
                        if (res[i][1] == table[j][0]) and (res[i][0] == table[j][1]) :
                            valsave = val
                        val = val + 1
                    fet = QgsFeature()
                    fet.setGeometry(QgsGeometry.fromPolyline(geo[valsave]))
                    fet.setAttributes([id, int(table[valsave][0]), int(table[valsave][1]), valsave + 1])
                    v.startEditing()
                    p.addFeatures( [ fet ] )
                    v.commitChanges()
                    id = id + 1
                QgsMapLayerRegistry.instance().addMapLayer(v)
        QMessageBox.information(None, " Message : ", "End")

  #----------------------------------------------------------------------------------------------------------------------------------------                 Tools             ----------------------------------------------------------------------------------------------------------------------------------- 
  def runf(self): 
        global canvas
        canvas = self.iface.mapCanvas()
        global allLayers
        allLayers = canvas.layers()
        global count
        count = canvas.layerCount()
        global lay
        lay=[]
        for i in allLayers:
           lay=lay+[str(i.name())]
        self.dlg = testDialogtool(self.iface.mainWindow())
        self.dlg.ui.comboBox.addItems(['Tables to Graph','Planar Graph', 'Correct ID'])
        QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calculf)
        self.dlg.show()

  def calculf(self):
        tool=self.dlg.ui.comboBox.currentText()
        if tool == 'Correct ID' :
            self.dlg2 = testDialog(self.iface.mainWindow())
            self.dlg2.ui.comboBox.addItems(lay)
            self.dlg2.ui.comboBox_2.addItems(lay)
            QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2fid)
            self.dlg2.show()
        if tool == 'Planar Graph' :
            global pg
            pg, ok = QInputDialog.getItem(None,"Planar Graph", "Choose your tool : ",["Create Planar Graph","Simplify Planar Graph", "Remove Leaves", "Remove Zero Degree Nodes"], editable = False )
            if ok :
                if str(pg) == "Create Planar Graph" :
                    self.dlg2 = testDialogtoolb(self.iface.mainWindow())
                    self.dlg2.ui.comboBox.addItems(lay)
                    QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2fpg)
                    self.dlg2.show()
                else :
                    self.dlg2 = testDialog(self.iface.mainWindow())
                    self.dlg2.ui.comboBox.addItems(lay)
                    self.dlg2.ui.comboBox_2.addItems(lay)
                    QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2fpgb)
                    self.dlg2.show()
        if tool == 'Tables to Graph' :
            self.dlg2 = testDialog(self.iface.mainWindow())
            self.dlg2.ui.comboBox.addItems(lay)
            self.dlg2.ui.comboBox_2.addItems(lay)
            QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2f)
            self.dlg2.show()

  def calcul2f(self):
        table_noeud=self.dlg2.ui.comboBox.currentText()
        table_arc=self.dlg2.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
        global nLayer
        nLayer = allLayers[int(ind_noeud)]
        global provider2
        provider2 = nLayer.dataProvider()
        global field2
        field2=provider2.fields()
        global fields2
        fields2=[]
        for i in range(field2.count()):
          fields2=fields2+[str(field2[i].name())]
        self.dlg3 = testDialogtoolTTP(self.iface.mainWindow())
        self.dlg3.ui.comboBox.addItems(fields2)
        self.dlg3.ui.comboBoxb.addItems(fields2)
        self.dlg3.ui.comboBoxc.addItems(fields2)
        self.dlg3.ui.comboBox2.addItems(fields)
        self.dlg3.ui.comboBox2b.addItems(fields)
        QObject.connect(self.dlg3.ui.buttonBox, SIGNAL("accepted()"), self.calcul3f)
        self.dlg3.show()

  def calcul2fpg(self):
        epsg=canvas.mapRenderer().destinationCrs().authid()
        table_arc=self.dlg2.ui.comboBox.currentText()
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        Layer = allLayers[int(ind_arc)]
        provider = Layer.dataProvider()
        tablex = []
        tabley = []
        ct = []
        tablegeom = []
        tablegeomnew = []
        tableid = []
        feat = QgsFeature()
        fit = provider.getFeatures()
        while fit.nextFeature(feat): 
            geom = feat.geometry()
            geomwkt = str(geom.exportToWkt())
            lignegeom = []
            if str(geomwkt[0:10])== 'LineString' or str(geomwkt[0:10])== 'LINESTRING' or str(geomwkt[0:10])== 'Linestring' or str(geomwkt[0:10])== 'linestring' :
                geomwkt2 = string.split(geomwkt,'(')
                geomwkt3 = string.split(geomwkt2[1],')')
                geomwkt4 = string.split(geomwkt3[0],',')
                for i in range(len(geomwkt4)):
                    geomwkt5 = string.split(geomwkt4[i],' ')
                    if i == 0 : 
                        x = float(geomwkt5[0])
                        y = float(geomwkt5[1])
                    if i != 0 : 
                        x = float(geomwkt5[1])
                        y = float(geomwkt5[2])
                    if i == 0 or i == len(geomwkt4)- 1 :
                        test = 0
                        for testx in enumerate(tablex):
                            if testx[1] == x :
                                if tabley[testx[0]] == y :
                                    test = 1
                                    a = testx[0]
                        if test == 0 :
                            tablex = tablex + [x]
                            tabley = tabley + [y]
                            ct = ct + [1]
                            if i == 0 :
                                id1 = len(tablex)
                            if i == len(geomwkt4)- 1 :
                                id2 = len(tabley)
                        if test == 1 :
                            ct [a] = ct[a] + 1
                            if i == 0 :
                                id1 = int(a) + 1
                            if i == len(geomwkt4)- 1 :
                                id2 = int(a) + 1
                    lignegeom = lignegeom + [[x,y]]
                tablegeom = tablegeom + [lignegeom[:]]
                tablegeomnew = tablegeomnew + [lignegeom[:]]
                tableid = tableid + [[id1, id2]]
            if str(geomwkt[0:15])== 'MultiLineString' or str(geomwkt[0:15])== 'MULTILINESTRING' or str(geomwkt[0:15])== 'Multilinestring' or str(geomwkt[0:15])== 'multilinestring' :
                geomwkt2 = string.split(geomwkt,'(')
                for j in range(len(geomwkt2)-2): 
                  lignegeompro = []
                  geomwkt3 = string.split(geomwkt2[j+2],')')
                  geomwkt4 = string.split(geomwkt3[0],',')
                  for i in range(len(geomwkt4)):
                    geomwkt5 = string.split(geomwkt4[i],' ')
                    if i == 0 : 
                        x = float(geomwkt5[0])
                        y = float(geomwkt5[1])
                    if i != 0 : 
                        x = float(geomwkt5[1])
                        y = float(geomwkt5[2])
                    if i == 0 or i == len(geomwkt4)- 1 :
                        test = 0
                        for testx in enumerate(tablex):
                            if testx[1] == x :
                                if tabley[testx[0]] == y :
                                    test=1
                                    a=testx[0]
                        if test == 0 :
                            tablex = tablex + [x]
                            tabley = tabley + [y]
                            ct = ct + [1]
                            if i == 0 :
                                id1 = len(tablex)
                            if i == len(geomwkt4)- 1 :
                                id2 = len(tabley)
                        if test == 1 :
                            ct [a] = ct[a] + 1
                            if i == 0 :
                                id1 = int(a) + 1
                            if i == len(geomwkt4)- 1 :
                                id2 = int(a) + 1
                    lignegeompro = lignegeompro + [[x,y]]
                  tableid = tableid + [[id1, id2]]
                  lignegeom = lignegeom + [lignegeompro[:]]
                tablegeom = tablegeom + lignegeom[:]
                tablegeomnew = tablegeomnew + lignegeom[:]
        for i in range(len(tablegeom)):
            compte = 0
            for j in range(len(tablegeom[i])-1): 
                line_feature = QgsFeature()
                line_feature.setGeometry( QgsGeometry.fromPolyline([ QgsPoint(tablegeom[i][j][0],tablegeom[i][j][1]),QgsPoint(tablegeom[i][j+1][0],tablegeom[i][j+1][1]) ]) )	 
                cands = Layer.getFeatures(QgsFeatureRequest().setFilterRect(line_feature.geometry().boundingBox()))
                stockpt = []
                for line_feature2 in cands:
                    if line_feature.geometry().intersects(line_feature2.geometry()):
                        intersection = line_feature.geometry().intersection(line_feature2.geometry()).exportToWkt() 
                        if str(intersection[0:5]) == 'Point':
                            geomwkt2 = string.split(intersection,'(')
                            geomwkt3 = string.split(geomwkt2[1],')')
                            geomwkt4 = string.split(geomwkt3[0],' ')
                            x = float(geomwkt4[0])
                            y = float(geomwkt4[1])
                            test = 0
                            for testx in enumerate(tablex):
                                if testx[1] == x :
                                    if tabley[testx[0]] == y :
                                        test=1
                                        a=testx[0]
                            if test == 0 :
                                tablex = tablex + [x]
                                tabley = tabley + [y]
                                ct = ct + [1]
                                id1 = len(tablex)
                            if test == 1 :
                                ct [a] = ct[a] + 1
                                id1 = int(a) + 1 
                            dist = abs(tablegeom[i][j][0] - x)
                            stockpt = stockpt + [[dist,x,y,id1]]
                        if str(intersection[0:10]) == 'MultiPoint':
                            geomwkt2 = string.split(intersection,'(')
                            for k in range(len(geomwkt2)-2):
                                geomwkt3 = string.split(geomwkt2[k+2],')')
                                geomwkt4 = string.split(geomwkt3[0],' ')
                                x = float(geomwkt4[0])
                                y = float(geomwkt4[1])
                                test = 0
                                for testx in enumerate(tablex):
                                    if testx[1] == x :
                                        if tabley[testx[0]] == y :
                                            test=1
                                            a=testx[0]
                                if test == 0 :
                                    tablex = tablex + [x]
                                    tabley = tabley + [y]
                                    ct = ct + [1]
                                    id1 = len(tablex)
                                if test == 1 :
                                    ct [a] = ct[a] + 1
                                    id1 = int(a) + 1 
                                dist = abs(tablegeom[i][j][0] - x)
                                stockpt = stockpt + [[dist,x,y,id1]]
                stockptri = sorted(stockpt)
                jb = compte + 2
                if len(stockpt) > 0:
                    iddep=tableid[i][0]
                    idarr=tableid[i][1]
                    for k in range(len(stockpt)):
                        ligne1 = tablegeomnew[i][0:jb]
                        ligne1[jb-1] = [stockptri[k][1],stockptri[k][2]]
                        if len(ligne1) > 2 :
                            tablegeomnew[i][0:jb-1] = [[stockptri[k][1],stockptri[k][2]]]
                            tableid[i] = [stockptri[k][3],idarr]
                        if len(ligne1) == 2 :
                            tablegeomnew[i][0:1] = [[stockptri[k][1],stockptri[k][2]]]
                            tableid[i] = [stockptri[k][3],idarr]
                        jb = 2	
                        tablegeomnew = tablegeomnew + [ligne1]	
                        tableid = tableid + [[iddep,stockptri[k][3]]]
                        iddep = stockptri[k][3]
                    compte = 0
                compte = compte + 1
        v = QgsVectorLayer("LineString?crs=epsg:"+str(epsg), "Edges", "memory")
        p = v.dataProvider()
        p.addAttributes( [QgsField("StartNode", QVariant.Int)] )
        p.addAttributes( [QgsField("EndNode", QVariant.Int)] )
        v.commitChanges()
        for i in range(len(tablegeomnew)):
            test = 0
            if len(tablegeomnew[i]) == 2 :
                if tablegeomnew[i][0][0] == tablegeomnew[i][1][0] :
                    if tablegeomnew[i][0][1] == tablegeomnew[i][1][1] :
                        test = 1
            if test == 0 :
                v.startEditing()
                fet = QgsFeature()
                textgeom = "LINESTRING(" + str(tablegeomnew[i][0][0]) + " " + str(tablegeomnew[i][0][1])
                for j in range(len(tablegeomnew[i])-1):
                    textgeom = textgeom + "," + str(tablegeomnew[i][j+1][0]) + " " + str(tablegeomnew[i][j+1][1])
                textgeom = textgeom + ")"
                fet.setGeometry(  QgsGeometry.fromWkt( textgeom ) )
                fet.setAttributes( [ int(tableid[i][0]) , int(tableid[i][1]) ] )
                p.addFeatures( [ fet ] )
                v.commitChanges()
        QgsMapLayerRegistry.instance().addMapLayer(v)
        v2 = QgsVectorLayer("Point?crs=epsg:"+str(epsg), "Nodes", "memory")
        p2 = v2.dataProvider()
        p2.addAttributes( [QgsField("ID", QVariant.Int)] )
        v2.commitChanges()
        for i in range(len(tablex)):
            v2.startEditing()
            fet = QgsFeature()
            textgeom = "POINT(" + str(tablex[i]) + " " + str(tabley[i]) + ")"
            fet.setGeometry(  QgsGeometry.fromWkt( textgeom ) )
            fet.setAttributes( [ int(i+1) ] )
            p2.addFeatures( [ fet ] )
            v2.commitChanges()
        QgsMapLayerRegistry.instance().addMapLayer(v2)	
        QMessageBox.information(None, " Message : ", "End")

  def calcul2fpgb(self):
        table_noeud=self.dlg2.ui.comboBox.currentText()
        table_arc=self.dlg2.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global eLayer
        eLayer = allLayers[int(ind_arc)]
        global provider2
        provider2 = eLayer.dataProvider()
        global field
        field=provider2.fields()
        global fields
        fields=[]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
        global nLayer
        nLayer = allLayers[int(ind_noeud)]
        global provider
        provider = nLayer.dataProvider()
        global field2
        field2=provider.fields()
        global fields2
        fields2=[]
        for i in range(field2.count()):
          fields2=fields2+[str(field2[i].name())]
        self.dlg3 = testDialogtool2(self.iface.mainWindow())
        self.dlg3.ui.comboBox.addItems(fields)
        self.dlg3.ui.comboBox2.addItems(fields)
        QObject.connect(self.dlg3.ui.buttonBox, SIGNAL("accepted()"), self.calcul3fpgb)
        self.dlg3.show()

  def calcul2fid(self):
        table_noeud=self.dlg2.ui.comboBox.currentText()
        table_arc=self.dlg2.ui.comboBox_2.currentText()
        global ind_noeud
        for j in range(count):
          if str(table_noeud)==str(lay[j]) :
            ind_noeud=j
        global ind_arc
        for j in range(count):
          if str(table_arc)==str(lay[j]) :
            ind_arc=j
        global aLayer
        aLayer = allLayers[int(ind_arc)]
        global provider
        provider = aLayer.dataProvider()
        global field
        field=provider.fields()
        global fields
        fields=[]
        for i in range(field.count()):
          fields=fields+[str(field[i].name())]
        global nLayer
        nLayer = allLayers[int(ind_noeud)]
        global provider2
        provider2 = nLayer.dataProvider()
        global field2
        field2=provider2.fields()
        global fields2
        fields2=[]
        for i in range(field2.count()):
          fields2=fields2+[str(field2[i].name())]
        self.dlg3 = testDialogtoolID(self.iface.mainWindow())
        self.dlg3.ui.comboBox.addItems(fields2)
        self.dlg3.ui.comboBox2.addItems(fields)
        self.dlg3.ui.comboBox3.addItems(fields)
        QObject.connect(self.dlg3.ui.buttonBox, SIGNAL("accepted()"), self.calcul3fid)
        self.dlg3.show()

  def calcul3f(self):
        arc_start=self.dlg3.ui.comboBox2.currentText()
        arc_end=self.dlg3.ui.comboBox2b.currentText()
        ID = self.dlg3.ui.comboBoxb.currentText()
        x = self.dlg3.ui.comboBox.currentText()
        y = self.dlg3.ui.comboBoxc.currentText()
        epsg = self.dlg3.ui.lineedit.text()
        Idind=provider2.fieldNameIndex(str(ID))
        xind=provider2.fieldNameIndex(str(x))
        yind=provider2.fieldNameIndex(str(y))
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        valID = []
        xval = []
        yval = []
        fit1 = provider2.getFeatures()
        feat = QgsFeature()
        v = QgsVectorLayer("Point?crs=epsg:"+str(epsg), "Nodes", "memory")
        p = v.dataProvider()
        for i in range(field2.count()):
            p.addAttributes( [field2[i]] )
        v.commitChanges()
        while fit1.nextFeature(feat):
            valID = valID + [feat.attributes()[Idind]]
            y1=feat.attributes()[yind]
            x1 = feat.attributes()[xind]
            yval = yval + [y1]
            xval = xval + [x1]
            att = feat.attributes()
            v.startEditing()
            fet = QgsFeature()
            fet.setGeometry(  QgsGeometry.fromPoint(QgsPoint(float(x1),float(y1))) )
            fet.setAttributes( att )
            p.addFeatures( [ fet ] )
            v.commitChanges()
        QgsMapLayerRegistry.instance().addMapLayer(v)
        fit2 = provider.getFeatures()
        feat2 = QgsFeature()
        vl = QgsVectorLayer("LineString?crs=epsg:"+str(epsg), "Edges", "memory")
        pr = vl.dataProvider()
        for i in range(field.count()):
            pr.addAttributes( [field[i]] )
        vl.commitChanges()
        while fit2.nextFeature(feat2):
            IDstart = feat2.attributes()[startind]
            IDend = feat2.attributes()[endind]
            num1 = valID.index(IDstart)
            num2 = valID.index(IDend)
            X1 = xval[num1]
            Y1 = yval[num1]
            X2 = xval[num2]
            Y2 = yval[num2]
            att = feat2.attributes()
            vl.startEditing()
            fet = QgsFeature()
            fet.setGeometry( QgsGeometry.fromPolyline([QgsPoint(float(X1),float(Y1)),QgsPoint(float(X2),float(Y2))]) )
            fet.setAttributes( att )
            pr.addFeatures( [ fet ] )
            vl.commitChanges()
        QgsMapLayerRegistry.instance().addMapLayer(vl)
		
  def calcul3fpgb(self):
        epsg=canvas.mapRenderer().destinationCrs().authid()
        arc_start=self.dlg3.ui.comboBox.currentText()
        arc_end=self.dlg3.ui.comboBox2.currentText()
        if str(pg) == "Simplify Planar Graph" : 
            nb = 2
        if str(pg) == "Remove Leaves" : 
            nb = 1
        if str(pg) == "Remove Zero Degree Nodes" :
            nb = 0
        champ1=provider2.fieldNameIndex(str(arc_start))
        champ2=provider2.fieldNameIndex(str(arc_end))
        feat = QgsFeature()
        fit = provider.getFeatures()
        v = QgsVectorLayer("Point?crs=epsg:"+str(epsg), "Nodes", "memory")
        p = v.dataProvider()
        p.addAttributes( [QgsField("ID", QVariant.Int)] )
        p.addAttributes( [QgsField("ID2", QVariant.Int)] )
        v.commitChanges()
        i = 1
        i2 = 0
        valconfig=0
        tablept=[]
        if nb == 2:
            ptsup = []
        while fit.nextFeature(feat):
            cands = eLayer.getFeatures(QgsFeatureRequest().setFilterRect(feat.geometry().boundingBox()))
            c = 0
            for line_feature in cands:
                if feat.geometry().intersects(line_feature.geometry()):
                    c = c + 1
            if c != nb:
                i2 = i2 + 1
                v.startEditing()
                fet = QgsFeature()
                fet.setGeometry(  feat.geometry() )
                fet.setAttributes( [ int(i), int(i2) ] )
                p.addFeatures( [ fet ] )
                v.commitChanges()
                tablept = tablept + [i]
            if c==2 :
                if nb==2 :
                    ptsup = ptsup + [i]
            i = i + 1
        QgsMapLayerRegistry.instance().addMapLayer(v)
        feat = QgsFeature()
        fit = provider2.getFeatures()
        v2 = QgsVectorLayer("LineString?crs=epsg:"+str(epsg), "Edges", "memory")
        p2 = v2.dataProvider()
        p2.addAttributes( [QgsField("StartNode", QVariant.Int)] )
        p2.addAttributes( [QgsField("EndNode", QVariant.Int)] )
        p2.addAttributes( [QgsField("StartNode2", QVariant.Int)] )
        p2.addAttributes( [QgsField("EndNode2", QVariant.Int)] )
        v2.commitChanges()
        i = 1
        i2 = 0
        tableconfig=[]
        while fit.nextFeature(feat):
            test = 0 
            start= int(feat.attributes()[champ1])
            for sid in enumerate(tablept):
                if sid[1] == start:
                    end = int(feat.attributes()[champ2])
                    for fid in enumerate(tablept) :
                        if fid[1] == end :
                            v2.startEditing()
                            fet = QgsFeature()
                            fet.setGeometry(  feat.geometry() )
                            fet.setAttributes( [ start, end, int(sid[0]+1) , int(fid[0]+1) ] )
                            p2.addFeatures( [ fet ] )
                            v2.commitChanges()
                            test = 1
            if test == 0 :
                tableconfig = tableconfig + [[str(feat.geometry().exportToWkt()),int(feat.attributes()[champ1]),int(feat.attributes()[champ2]),valconfig]]
                valconfig = valconfig + 1
        if nb == 2 :
            newrac = []
            for eltsup in (ptsup):
                geom2ligne=[]
                idarc=[]
                for i in range(len(tableconfig)):
                    if int(tableconfig[i][1]) == eltsup :
                        geom =tableconfig[i][0]
                        geom2 = string.split(geom,'(')
                        geom3 = string.split(geom2[1],')')
                        try :
                            idarc.index(tableconfig[i][3])
                            test = 1
                        except :
                            test = 0
                        if test == 0:
                            geom2ligne = geom2ligne + [[1, geom3[0], int(tableconfig[i][2]),tableconfig[i][3]]]
                            idarc = idarc + [tableconfig[i][3]]
                    if int(tableconfig[i][2]) == eltsup :
                        geom =tableconfig[i][0]
                        geom2 = string.split(geom,'(')
                        geom3 = string.split(geom2[1],')')
                        try :
                            idarc.index(tableconfig[i][3])
                            test = 1
                        except :
                            test = 0
                        if test == 0:
                            geom2ligne = geom2ligne + [[2, geom3[0], int(tableconfig[i][1]),tableconfig[i][3]]]
                            idarc = idarc + [tableconfig[i][3]]
                if geom2ligne[0][0] == 1:
                    if geom2ligne[1][0] == 2:
                        geomdef = 'LineString('+geom2ligne[1][1]+','+geom2ligne[0][1]+')'
                        id1 = geom2ligne[1][2]
                        id2 = geom2ligne[0][2]
                    if geom2ligne[1][0] == 1:
                        newgeom = ''
                        geom4 = string.split(geom2ligne[1][1],',')
                        for i in range(len(geom4)):
                            if i != 0 :
                                newgeom=newgeom+','+str(geom4[len(geom4)-i-1])
                            if i == 0 :
                                newgeom = str(geom4[len(geom4)-i-1])
                        geomdef = 'LineString('+newgeom+','+geom2ligne[0][1]+')'
                        id1 = geom2ligne[1][2]
                        id2 = geom2ligne[0][2]
                if geom2ligne[0][0] == 2:
                    if geom2ligne[1][0] == 1:
                        geomdef = 'LineString('+geom2ligne[0][1]+','+geom2ligne[1][1]+')'
                        id1 = geom2ligne[0][2]
                        id2 = geom2ligne[1][2]
                    if geom2ligne[1][0] == 2:
                        newgeom = ''
                        geom4 = string.split(geom2ligne[1][1],',')
                        for i in range(len(geom4)):
                            if i != 0 :
                                newgeom=newgeom+','+str(geom4[len(geom4)-i-1])
                            if i == 0 :
                                 newgeom = str(geom4[len(geom4)-i-1])
                        geomdef = 'LineString('+geom2ligne[0][1]+','+newgeom+')'
                        id1 = geom2ligne[0][2]
                        id2 = geom2ligne[1][2]
                tableconfig[idarc[0]][0] = geomdef[:]
                tableconfig[idarc[0]][1] = id1
                tableconfig[idarc[0]][2] = id2
                tableconfig[idarc[0]][3] = idarc[0]
                tableconfig[idarc[1]][0] = geomdef[:]
                tableconfig[idarc[1]][1] = id1
                tableconfig[idarc[1]][2] = id2
                tableconfig[idarc[1]][3] = idarc[0]
                try :
                    a1 = int(tablept.index(id1)) + 1
                    testdef = 0
                except :
                    testdef = 1
                if testdef == 0 :
                    try :
                        a2 = tablept.index(id2) + 1
                        testdef = 0
                    except:
                        testdef = 1
                if testdef == 0 :
                    v2.startEditing()
                    fet = QgsFeature()
                    fet.setGeometry(  QgsGeometry.fromWkt( geomdef[:] ) )
                    fet.setAttributes( [ id1, id2, int(a1) , int(a2) ] )
                    p2.addFeatures( [ fet ] )
                    v2.commitChanges()             
        QgsMapLayerRegistry.instance().addMapLayer(v2)
        QMessageBox.information(None, " Message : ", "End")

  def calcul3fid(self):
        arc_start=self.dlg3.ui.comboBox2.currentText()
        arc_end=self.dlg3.ui.comboBox3.currentText()
        ID = self.dlg3.ui.comboBox.currentText()
        Idind=provider2.fieldNameIndex(str(ID))
        startind=provider.fieldNameIndex(str(arc_start))
        endind=provider.fieldNameIndex(str(arc_end))
        nbcol=int(provider2.fields().count())
        provider2.addAttributes( [QgsField("AnNet", QVariant.Int)] )
        nLayer.commitChanges()
        feat = QgsFeature()
        fit1 = provider2.getFeatures()
        olderID = []
        i=0
        nLayer.startEditing()
        while fit1.nextFeature(feat):
            olderID = olderID + [feat.attributes()[Idind]]
            nLayer.changeAttributeValue(i,nbcol, int(i+1))
            i = i + 1
        nLayer.commitChanges()
        nbcol=int(provider.fields().count())
        provider.addAttributes( [QgsField("AnNet", QVariant.Int)] )
        provider.addAttributes( [QgsField("StartNode", QVariant.Int)] )
        provider.addAttributes( [QgsField("EndNode", QVariant.Int)] )
        aLayer.commitChanges()
        feat2 = QgsFeature()
        fit2 = provider.getFeatures()
        i=0
        aLayer.startEditing()
        while fit2.nextFeature(feat2):
            dep = int(olderID.index(feat2.attributes()[startind]))+1
            fin = int(olderID.index(feat2.attributes()[endind]))+1
            aLayer.changeAttributeValue(i,nbcol, int(i+1))
            aLayer.changeAttributeValue(i,nbcol+1, dep)
            aLayer.changeAttributeValue(i,nbcol+2, fin)
            i = i + 1
        aLayer.commitChanges()
        QMessageBox.information(None, " Message : ", "End")

