from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import * 
from testdialog import testDialog
from testdialog2 import testDialog2
import urllib
import time

# Our main class for the plugin
class GCode:

  def __init__(self, iface):
    # Save reference to the QGIS interface
    self.iface = iface

  def initGui(self):
    # Create action that will start plugin configuration
    self.action = QAction("GeoCoder", self.iface.mainWindow())
    QObject.connect(self.action, SIGNAL("activated()"), self.run)

    # Add toolbar button and menu item
    self.iface.addPluginToMenu("&GeoCodage...", self.action)

  def unload(self):
    # Remove the plugin menu item and icon
    self.iface.removePluginMenu("&GeoCodage..",self.action)
    #self.iface.removeToolBarIcon(self.action)

  def run(self): 
         global canvas
         canvas = self.iface.mapCanvas()
         global allLayers
         allLayers = canvas.layers()
         global count
         count = canvas.layerCount()
         global lay
         lay=[]
         for i in allLayers:
             lay=lay+[str(i.name())]
         global table
         self.dlg = testDialog(self.iface.mainWindow())
         self.dlg.ui.comboBox.addItems(lay)
         QObject.connect(self.dlg.ui.buttonBox, SIGNAL("accepted()"), self.calcul)
         self.dlg.show()

  def calcul(self):
         table=self.dlg.ui.comboBox.currentText()
         global ind_table
         for j in range(count):
             if str(table)==str(lay[j]) :
                 ind_table=j
         global aLayer
         aLayer = allLayers[int(ind_table)]
         global provider
         provider = aLayer.dataProvider()
         global field
         field=provider.fields()
         global fields
         fields=[]
         for i in range(field.count()):
             fields=fields+[str(field[i].name())]
         self.dlg2 = testDialog2(self.iface.mainWindow())
         self.dlg2.ui.comboBox.addItems(fields)
         self.dlg2.ui.comboBox_6.addItems(["Google","OSM (Photon)","OSM (Nominatim)"]) 
         self.dlg2.ui.lineEdit_11.setText("4326") 
         QObject.connect(self.dlg2.ui.buttonBox, SIGNAL("accepted()"), self.calcul2)
         self.dlg2.show()

  def calcul2(self):
         outil=self.dlg2.ui.comboBox_6.currentText()
         EPSG=self.dlg2.ui.lineEdit_11.text()
         if str(outil)=="Google":
             champs= self.dlg2.ui.lineEdit_10.text()
             chp=champs.split(";")
             length=len(chp)
             champind=provider.fieldNameIndex(str(chp[0]))
             feat = QgsFeature()
             fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
             table=[]
             k=0
             while fit1.nextFeature(feat):
                 attrsstart=str(feat.attributes()[champind])  
                 table=table+[attrsstart]
                 k=k+1
             if length>1:
                 taille=length-1
                 for i in range(taille):
                     j=i+1
                     champind=provider.fieldNameIndex(str(chp[j]))
                     feat = QgsFeature()
                     fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
                     k=0
                     while fit1.nextFeature(feat):
                         attrsstart=str(feat.attributes()[champind])  
                         table[k]=str(table[k])+"+"+str(attrsstart)
                         k=k+1
             if EPSG=="4326":
                 vl = QgsVectorLayer("Point?crs=epsg:4326", "Tentative", "memory")
             if EPSG!="4326":
                 vl = QgsVectorLayer("Point?crs=epsg:"+str(EPSG), "Tentative", "memory")
             pr = vl.dataProvider()
             vl.startEditing()
             fet = QgsFeature()
             for i in range(k):
                 req="https://maps.googleapis.com/maps/api/geocode/xml?address="
                 reqfin= str(req)+str(table[i])
                 f2 = urllib.urlopen(reqfin)
                 d2=f2.read()
                 lat=d2.split("<lat>")
                 lat2=lat[1].split("</lat>")
                 y=lat2[0]
                 lon=d2.split("<lng>")
                 lon2=lon[1].split("</lng>")
                 x=lon2[0]
                 time.sleep(2)
                 if EPSG=="4326":
                     fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(float(x),float(y))) )
                 if EPSG!="4326":
                     crsSrc = QgsCoordinateReferenceSystem(4326)    # WGS 84
                     crsDest = QgsCoordinateReferenceSystem(int(EPSG)) 
                     xform = QgsCoordinateTransform(crsSrc, crsDest)
                     pt = xform.transform(QgsPoint(float(x),float(y)))
                     fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(pt)) )
                 pr.addFeatures( [ fet ] )
             vl.commitChanges()
             QgsMapLayerRegistry.instance().addMapLayer(vl)
             pr = vl.dataProvider()
             vl.startEditing()
             for i in range(len(fields)):
                 pr.addAttributes( [ QgsField(str(fields[i]), QVariant.String) ] )
             vl.commitChanges()
             pr = vl.dataProvider()
             vl.startEditing()
             for i in range(len(fields)):
                 feat = QgsFeature()
                 fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([i]))
                 k=1
                 while fit1.nextFeature(feat):
                     attr=str(feat.attributes()[i])  
                     vl.changeAttributeValue(k,i,str(attr))
                     k=k+1
             vl.commitChanges()
             #extent = vl.extent()
             #QMessageBox.information(None, " message final : ", str(extent))
             #canvas = self.iface.mapCanvas()
             #canvas.setExtent(extent)
             #canvas.refresh() 
             #canvas.zoomToFullExtent()
             QMessageBox.information(None, " message final : ", "Fin")
         if str(outil)=="OSM (Photon)":
             champs= self.dlg2.ui.lineEdit_10.text()
             chp=champs.split(";")
             length=len(chp)
             champind=provider.fieldNameIndex(str(chp[0]))
             feat = QgsFeature()
             fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
             table=[]
             k=0
             while fit1.nextFeature(feat):
                 attrsstart=str(feat.attributes()[champind])  
                 table=table+[attrsstart]
                 k=k+1
             if length>1:
                 taille=length-1
                 for i in range(taille):
                     j=i+1
                     champind=provider.fieldNameIndex(str(chp[j]))
                     feat = QgsFeature()
                     fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
                     k=0
                     while fit1.nextFeature(feat):
                         attrsstart=str(feat.attributes()[champind])  
                         table[k]=str(table[k])+"+"+str(attrsstart)
                         k=k+1
             if EPSG=="4326":
                 vl = QgsVectorLayer("Point?crs=epsg:4326", "Tentative", "memory")
             if EPSG!="4326":
                 vl = QgsVectorLayer("Point?crs=epsg:"+str(EPSG), "Tentative", "memory")
             pr = vl.dataProvider()
             vl.startEditing()
             fet = QgsFeature()
             for i in range(k):
                 req="http://photon.komoot.de/api/?q="
                 reqfin= str(req)+str(table[i])
                 f2 = urllib.urlopen(reqfin)
                 d2=f2.read()
                 lon=d2.split('coordinates":[')
                 lon2=lon[1].split(",")
                 x=lon2[0]
                 lat=lon2[1].split("]")
                 y=lat[0]
                 if EPSG=="4326":
                     fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(float(x),float(y))) )
                 if EPSG!="4326":
                     crsSrc = QgsCoordinateReferenceSystem(4326)    # WGS 84
                     crsDest = QgsCoordinateReferenceSystem(int(EPSG)) 
                     xform = QgsCoordinateTransform(crsSrc, crsDest)
                     pt = xform.transform(QgsPoint(float(x),float(y)))
                     fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(pt)) )
                 pr.addFeatures( [ fet ] )
             vl.commitChanges()
             QgsMapLayerRegistry.instance().addMapLayer(vl)
             pr = vl.dataProvider()
             vl.startEditing()
             for i in range(len(fields)):
                 pr.addAttributes( [ QgsField(str(fields[i]), QVariant.String) ] )
             vl.commitChanges()
             pr = vl.dataProvider()
             vl.startEditing()
             for i in range(len(fields)):
                 feat = QgsFeature()
                 fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([i]))
                 k=1
                 while fit1.nextFeature(feat):
                     attr=str(feat.attributes()[i])  
                     vl.changeAttributeValue(k,i,str(attr))
                     k=k+1
             vl.commitChanges()
             QMessageBox.information(None, " message final : ", "Fin")
         if str(outil)=="OSM (Nominatim)":
             champs= self.dlg2.ui.lineEdit_10.text()
             chp=champs.split(";")
             length=len(chp)
             champind=provider.fieldNameIndex(str(chp[0]))
             feat = QgsFeature()
             fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
             table=[]
             k=0
             while fit1.nextFeature(feat):
                 attrsstart=str(feat.attributes()[champind])  
                 table=table+[attrsstart]
                 k=k+1
             if length>1:
                 taille=length-1
                 for i in range(taille):
                     j=i+1
                     champind=provider.fieldNameIndex(str(chp[j]))
                     feat = QgsFeature()
                     fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([champind]))
                     k=0
                     while fit1.nextFeature(feat):
                         attrsstart=str(feat.attributes()[champind])  
                         table[k]=str(table[k])+"+"+str(attrsstart)
                         k=k+1
             if EPSG=="4326":
                 vl = QgsVectorLayer("Point?crs=epsg:4326", "Tentative", "memory")
             if EPSG!="4326":
                 vl = QgsVectorLayer("Point?crs=epsg:"+str(EPSG), "Tentative", "memory")
             pr = vl.dataProvider()
             vl.startEditing()
             fet = QgsFeature()
             for i in range(k):
                 req="http://nominatim.openstreetmap.org/search?q="
                 reqfin= str(req)+str(table[i])+"&format=xml"
                 f2 = urllib.urlopen(reqfin)
                 d2=f2.read()
                 lat=d2.split("lat='")
                 lat2=lat[1].split("'")
                 y=lat2[0]
                 lon=d2.split("lon='")
                 lon2=lon[1].split("'")
                 x=lon2[0]
                 time.sleep(2)
                 if EPSG=="4326":
                     fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(float(x),float(y))) )
                 if EPSG!="4326":
                     crsSrc = QgsCoordinateReferenceSystem(4326)    # WGS 84
                     crsDest = QgsCoordinateReferenceSystem(int(EPSG)) 
                     xform = QgsCoordinateTransform(crsSrc, crsDest)
                     pt = xform.transform(QgsPoint(float(x),float(y)))
                     fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(pt)) )
                 pr.addFeatures( [ fet ] )
             vl.commitChanges()
             QgsMapLayerRegistry.instance().addMapLayer(vl)
             pr = vl.dataProvider()
             vl.startEditing()
             for i in range(len(fields)):
                 pr.addAttributes( [ QgsField(str(fields[i]), QVariant.String) ] )
             vl.commitChanges()
             pr = vl.dataProvider()
             vl.startEditing()
             for i in range(len(fields)):
                 feat = QgsFeature()
                 fit1 = provider.getFeatures(QgsFeatureRequest().setSubsetOfAttributes([i]))
                 k=1
                 while fit1.nextFeature(feat):
                     attr=str(feat.attributes()[i])  
                     vl.changeAttributeValue(k,i,str(attr))
                     k=k+1
             vl.commitChanges()
             QMessageBox.information(None, " message final : ", "Fin")


